/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TriggerWhenClauseTest
extends BaseJDBCTestCase {
    private static List<Integer> procedureCalls;
    private static final String SYNTAX_ERROR = "42X01";
    private static final String REFERENCES_SESSION_SCHEMA = "XCL51";
    private static final String NOT_BOOLEAN = "42X19";
    private static final String HAS_PARAMETER = "42Y27";
    private static final String HAS_DEPENDENTS = "X0Y25";
    private static final String TABLE_DOES_NOT_EXIST = "42X05";
    private static final String TRUNCATION = "22001";
    private static final String NOT_AUTHORIZED = "42504";
    private static final String NO_TABLE_PERMISSION = "42500";
    private static final String USER_EXCEPTION = "38000";
    private static final String JAVA_EXCEPTION = "XJ001";
    private static final String NOT_SINGLE_COLUMN = "42X39";
    private static final String NON_SCALAR_QUERY = "21000";
    private static final String TRIGGER_RECURSION = "54038";
    private static final String PROC_USED_AS_FUNC = "42Y03";

    public TriggerWhenClauseTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.sqlAuthorizationDecorator((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(TriggerWhenClauseTest.class)));
    }

    @Override
    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    protected void setUp() {
        procedureCalls = Collections.synchronizedList(new ArrayList());
    }

    @Override
    protected void tearDown() throws Exception {
        procedureCalls = null;
        super.tearDown();
    }

    public static void intProcedure(int i) {
        procedureCalls.add(i);
    }

    public void testBasicSyntax() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(y varchar(20))");
        s.execute("create trigger tr01 after insert on t1 for each row when (true) insert into t2 values 'Executed tr01'");
        s.execute("create trigger tr02 after insert on t1 for each statement when (true) insert into t2 values 'Executed tr02'");
        s.execute("create trigger tr03 after insert on t1 when (true) insert into t2 values 'Executed tr03'");
        s.execute("create trigger tr04 after insert on t1 for each row when (false) insert into t2 values 'Executed tr04'");
        s.execute("create trigger tr05 after insert on t1 for each statement when (false) insert into t2 values 'Executed tr05'");
        s.execute("create trigger tr06 after insert on t1 when (false) insert into t2 values 'Executed tr06'");
        s.execute("create trigger tr07 after insert on t1 when (exists (select * from sysibm.sysdummy1)) insert into t2 values 'Executed tr07'");
        s.execute("create trigger tr08 after insert on t1 when (exists (select * from sysibm.sysdummy1 where ibmreqd <> 'Y')) insert into t2 values 'Executed tr08'");
        s.execute("create trigger tr09 after insert on t1 when (cast(null as boolean))insert into t2 values 'Executed tr09'");
        s.execute("create trigger tr10 after insert on t1 referencing new as new for each row when (new.x <> 2) insert into t2 values 'Executed tr10'");
        s.execute("create trigger tr11 after insert on t1 referencing new table as new when (exists (select * from new where x > 5)) insert into t2 values 'Executed tr11'");
        this.assertCompileError(SYNTAX_ERROR, "create trigger tr12 after insert on t1 when (values true) insert into t2 values 'Executed tr12'");
        this.assertCompileError(SYNTAX_ERROR, "create trigger tr13 after insert on t1 when (select true from sysibm.sysdummy1) insert into t2 values 'Executed tr13'");
        s.execute("create trigger tr12 after insert on t1 when ((values true)) insert into t2 values 'Executed tr12'");
        s.execute("create trigger tr13 after insert on t1 when ((select true from sysibm.sysdummy1)) insert into t2 values 'Executed tr13'");
        TriggerWhenClauseTest.assertUpdateCount(s, 3, "insert into t1 values 1, 2, 3");
        JDBC.assertFullResultSet(s.executeQuery("select y, count(*) from t2 group by y order by y"), new String[][]{{"Executed tr01", "3"}, {"Executed tr02", "1"}, {"Executed tr03", "1"}, {"Executed tr07", "1"}, {"Executed tr10", "2"}, {"Executed tr12", "1"}, {"Executed tr13", "1"}});
        s.execute("delete from t2");
        TriggerWhenClauseTest.assertUpdateCount(s, 2, "insert into t1 values 2, 6");
        JDBC.assertFullResultSet(s.executeQuery("select y, count(*) from t2 group by y order by y"), new String[][]{{"Executed tr01", "2"}, {"Executed tr02", "1"}, {"Executed tr03", "1"}, {"Executed tr07", "1"}, {"Executed tr10", "1"}, {"Executed tr11", "1"}, {"Executed tr12", "1"}, {"Executed tr13", "1"}});
    }

    public void testSubqueryInWhenClauseNPE() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int)");
        s.execute("create trigger tr1 after insert on t1 for each row when ((values true)) insert into t2 values 1");
        s.execute("insert into t1 values 1,2,3");
    }

    public void testGeneratedColumns() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int, y int, z int generated always as (x+y))");
        s.execute("create table t2(x int)");
        s.execute("create procedure int_proc(i int) language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".intProcedure' no sql");
        s.execute("create trigger btr1 no cascade before insert on t1 referencing new as new for each row when (new.x < new.y) call int_proc(1)");
        this.assertCompileError("42XAA", "create trigger btr2 no cascade before insert on t1 referencing new as new for each row when (new.x < new.z) select * from sysibm.sysdummy1");
        s.execute("create trigger btr3 no cascade before update on t1 referencing new as new old as old for each row when (new.x < old.x) call int_proc(3)");
        s.execute("create trigger btr4 no cascade before update on t1 referencing old as old for each row when (old.x < old.z) call int_proc(4)");
        this.assertCompileError("42XAA", "create trigger btr5 no cascade before update on t1 referencing new as new for each row when (new.x < new.z) select * from sysibm.sysdummy1");
        s.execute("create trigger btr6 no cascade before delete on t1 referencing old as old for each row when (old.x < 3) call int_proc(6)");
        s.execute("create trigger btr7 no cascade before delete on t1 referencing old as old for each row when (old.x < old.z) call int_proc(7)");
        s.execute("create trigger atr1 after insert on t1 referencing new as new for each row when (new.x < new.z) insert into t2 values 1");
        s.execute("create trigger atr2 after update on t1 referencing new as new old as old for each row when (old.z < new.z) insert into t2 values 2");
        s.execute("create trigger atr3 after delete on t1 referencing old as old for each row when (old.x < old.z) insert into t2 values 3");
        s.execute("insert into t1(x, y) values (1, 2), (4, 3)");
        s.execute("update t1 set x = y");
        s.execute("delete from t1");
        TriggerWhenClauseTest.assertEquals(Arrays.asList(1, 3, 4, 4, 6, 7, 7), procedureCalls);
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by x"), new String[][]{{"1"}, {"1"}, {"2"}, {"3"}, {"3"}});
    }

    public void testIllegalWhenClauses() throws SQLException {
        Statement s = this.createStatement();
        s.execute("declare global temporary table temptable (x int) not logged");
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int)");
        s.execute("create procedure int_proc(i int) language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".intProcedure' no sql");
        this.assertCompileError(REFERENCES_SESSION_SCHEMA, "create trigger tr1 after insert on t1 when (exists (select * from session.temptable)) insert into t2 values 1");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr after insert on t1 when (1) insert into t2 values 1");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr after update on t1 when ('abc') insert into t2 values 1");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr after delete on t1 when ((values 1)) insert into t2 values 1");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr no cascade before insert on t1 when ((select ibmreqd from sysibm.sysdummy1)) call int_proc(1)");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr no cascade before insert on t1 when ((select ibmreqd from sysibm.sysdummy1)) call int_proc(1)");
        this.assertCompileError(NOT_BOOLEAN, "create trigger tr no cascade before update on t1 referencing old as old for each row when (old.x) call int_proc(1)");
        this.assertCompileError(HAS_PARAMETER, "create trigger tr no cascade before delete on t1 when (?) call int_proc(1)");
        this.assertCompileError(HAS_PARAMETER, "create trigger tr after insert on t1 when (cast(? as boolean)) call int_proc(1)");
        this.assertCompileError(HAS_PARAMETER, "create trigger tr after delete on t1 when ((select true from sysibm.sysdummy where ibmreqd = ?)) call int_proc(1)");
        this.assertCompileError(NOT_SINGLE_COLUMN, "create trigger tr no cascade before insert on t1 when ((values (true, false))) call int_proc(1)");
        this.assertCompileError(NOT_SINGLE_COLUMN, "create trigger tr after update of x on t1 when ((select tablename, schemaid from sys.systables)) call int_proc(1)");
    }

    public void testWhenClauseInvalidation() throws SQLException {
        PreparedStatement spsValid = this.prepareStatement("select valid from sys.sysstatements where stmtname like 'TRIGGERWHEN%'");
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int)");
        s.execute("create table t3(x int)");
        s.execute("insert into t1 values 1");
        s.execute("create trigger tr after insert on t2 referencing new as new for each row when (exists (select * from t1 where x = new.x)) insert into t3 values new.x");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        PreparedStatement compress = this.prepareStatement("call syscs_util.syscs_compress_table(?, 'T1', 1)");
        compress.setString(1, TestConfiguration.getCurrent().getUserName());
        compress.execute();
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "false");
        s.execute("insert into t2 values 0,1,2");
        JDBC.assertSingleValueResultSet(spsValid.executeQuery(), "true");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t3"), "1");
    }

    public void testDependencies() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int, y int, z int)");
        s.execute("create table t2(x int, y int, z int)");
        Savepoint sp = this.getConnection().setSavepoint();
        s.execute("create trigger tr after insert on t1 referencing new as new for each row when (new.x < new.y) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        s.execute("alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr no cascade before delete on t1 referencing old as old for each row when (old.x < old.y) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        s.execute("alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr no cascade before update on t1 referencing old as old new as new for each row when (old.x < new.y) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        s.execute("alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr no cascade before insert on t1 referencing new as new for each row when (new.x < 5) values new.y");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        s.execute("alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr after update of x on t1 referencing new table as new when (exists (select 1 from new where x < y)) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr after delete on t1 referencing old table as old when (exists (select 1 from old where x < y)) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr after delete on t1 referencing old table as old when (exists (select 1 from t1 where x < y)) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t1 drop column y restrict");
        s.execute("alter table t1 drop column z restrict");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr after insert on t1 when (exists (select * from t2 where x < y)) values 1");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t2 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t2 drop column y restrict");
        s.execute("alter table t2 drop column z restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "drop table t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select triggername from sys.systriggers"), "TR");
        s.executeUpdate("insert into t1 values (1, 2, 3)");
        this.getConnection().rollback(sp);
        s.execute("create trigger tr after update on t1 when (exists (select * from t2 where x < 5)) select y from t2");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t2 drop column x restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "alter table t2 drop column y restrict");
        s.execute("alter table t2 drop column z restrict");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s, "drop table t2");
        JDBC.assertSingleValueResultSet(s.executeQuery("select triggername from sys.systriggers"), "TR");
        this.getConnection().rollback(sp);
    }

    public void testDerby4874() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t(x varchar(3))");
        s.execute("create trigger tr after update of x on t referencing new as new for each row when (new.x < 'abc') values 1");
        s.execute("insert into t values 'aaa'");
        TriggerWhenClauseTest.assertStatementError(TRUNCATION, s, "update t set x = 'aaaa'");
        s.execute("alter table t alter x set data type varchar(4)");
        TriggerWhenClauseTest.assertUpdateCount(s, 1, "update t set x = 'aaaa'");
        TriggerWhenClauseTest.assertStatementError(TRUNCATION, s, "update t set x = 'aaaaa'");
    }

    public void testCloudscapeBug4821() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table cs4821.t(x int)");
        s.execute("create trigger cs4821.tr after insert on cs4821.t when (true) values 1");
        s.execute("alter table cs4821.t add column y int");
        this.commit();
        s.execute("insert into cs4821.t(x) values 1");
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        JDBC.assertDrainResults(s2.executeQuery("select * from sys.sysstatements"));
        s2.close();
        JDBC.cleanup(c2);
        JDBC.dropSchema(this.getConnection().getMetaData(), "CS4821");
    }

    public void testDerby6783() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE tabDerby6783(id INTEGER, result VARCHAR(10), status CHAR(1))");
        s.execute("CREATE TRIGGER trigger6783 AFTER UPDATE OF status ON tabDerby6783 REFERENCING NEW AS newrow FOR EACH ROW WHEN (newrow.status='d') UPDATE tabDerby6783 SET result='completed' WHERE id=newrow.id");
        s.execute("insert into tabDerby6783 values (1, null, 'a')");
        s.execute("UPDATE tabDerby6783 SET status='d'");
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT result FROM tabDerby6783"), "completed");
    }

    public void testDerby6783_1_1() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE tabDerby6783_1_1(ID INTEGER, GRADE1 char(1), GRADE2 char(1), MARKS1 integer, MARKS2 integer, TOTAL_MARKS integer)");
        s.execute("CREATE TRIGGER trigger6783_1 AFTER UPDATE OF GRADE1, GRADE2 ON tabDerby6783_1_1 REFERENCING NEW AS newrow OLD AS oldrow FOR EACH ROW WHEN (oldrow.GRADE1 <> newrow.GRADE1 OR oldrow.GRADE2 <> newrow.GRADE2) UPDATE tabDerby6783_1_1 SET TOTAL_MARKS = oldrow.MARKS1 + oldrow.MARKS2 where id=newrow.id");
        s.execute("INSERT INTO tabDerby6783_1_1 VALUES (1, 'a', 'b', 30, 50, 0)");
        s.execute("UPDATE tabDerby6783_1_1 SET GRADE1='b'");
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT TOTAL_MARKS FROM tabDerby6783_1_1"), "80");
    }

    public void testDerby6783_1_2() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE tabDerby6783_1_2(ID INTEGER, GRADE1 char(1), GRADE2 char(1), MARKS1 integer, MARKS2 integer, FINAL_GRADE char(1))");
        s.execute("CREATE TRIGGER trigger6783_1 AFTER UPDATE OF MARKS1 ON tabDerby6783_1_2  REFERENCING NEW AS newrow OLD AS oldrow FOR EACH ROW WHEN (oldrow.MARKS1 <> newrow.MARKS1) UPDATE tabDerby6783_1_2 SET FINAL_GRADE = oldrow.GRADE1 where id=newrow.id");
        s.execute("INSERT INTO tabDerby6783_1_2 VALUES (1, 'a', 'b', 30, 50, 'c')");
        s.execute("UPDATE tabDerby6783_1_2 SET MARKS1=20");
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT FINAL_GRADE FROM tabDerby6783_1_2"), "a");
    }

    public void testDerby6783_2() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE tabDerby6783_2(ACC_NUMBER INT, BALANCE FLOAT, RATE REAL, INTEREST REAL)");
        s.execute("CREATE TRIGGER trigger_2 AFTER UPDATE OF BALANCE ON tabDerby6783_2  REFERENCING NEW AS newrow OLD AS oldrow FOR EACH ROW WHEN (oldrow.RATE < 10.0) UPDATE tabDerby6783_2 SET INTEREST = oldrow.balance + newrow.BALANCE * RATE");
        s.execute("INSERT INTO tabDerby6783_2 VALUES (123, 12383.4534, 8.98, 2340)");
        s.execute("UPDATE tabDerby6783_2 SET BALANCE=22383.4543");
        s.execute("select INTEREST from tabDerby6783_2");
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT INTEREST FROM tabDerby6783_2"), "213386.86");
    }

    public void testDerby6783_3() throws SQLException {
        Statement s = this.createStatement();
        s.execute("CREATE TABLE tabDerby6783_3_1(FIELD1 VARCHAR(10), FIELD2 DOUBLE)");
        s.execute("INSERT INTO tabDerby6783_3_1 VALUES ('helloworld', 5454567)");
        s.execute("CREATE TABLE tabDerby6783_3_2(FIELD3 NUMERIC (7,1))");
        s.execute("INSERT INTO tabDerby6783_3_2 VALUES (3.143)");
        s.execute("CREATE TRIGGER TRIGGER_3 AFTER UPDATE OF FIELD1 ON tabDerby6783_3_1 REFERENCING NEW AS newrow OLD AS oldrow FOR EACH ROW WHEN (newrow.FIELD2 > 3000) UPDATE tabDerby6783_3_2 SET FIELD3 = newrow.FIELD2 / 10");
        s.execute("UPDATE tabDerby6783_3_1 set FIELD1='hello'");
        JDBC.assertSingleValueResultSet(s.executeQuery("SELECT FIELD3 FROM tabDerby6783_3_2"), "545456.7");
    }

    public void testGrantRevoke() throws SQLException {
        Connection c1 = this.openDefaultConnection("u1", "dummy");
        c1.setAutoCommit(true);
        Statement s1 = c1.createStatement();
        s1.execute("create table t1(x varchar(20))");
        s1.execute("create table t2(x varchar(200))");
        s1.execute("create table t3(x int)");
        s1.execute("create function is_true(s varchar(128)) returns boolean deterministic language java parameter style java external name 'java.lang.Boolean.parseBoolean' no sql");
        s1.execute("create trigger tr1 after insert on t1 referencing new as new for each row when (is_true(new.x)) insert into t2(x) values new.x");
        s1.execute("create trigger tr2 after insert on t1 when (exists (select * from t3 offset 1 row)) insert into t2(x) values '***'");
        s1.execute("grant insert on table t1 to u2");
        Connection c2 = this.openDefaultConnection("u2", "dummy");
        c2.setAutoCommit(true);
        Statement s2 = c2.createStatement();
        TriggerWhenClauseTest.assertStatementError(NOT_AUTHORIZED, s2, "values u1.is_true('abc')");
        TriggerWhenClauseTest.assertUpdateCount(s2, 4, "insert into u1.t1(x) values 'abc', 'true', 'TrUe', 'false'");
        JDBC.assertFullResultSet(s1.executeQuery("select * from t2 order by x"), new String[][]{{"TrUe"}, {"true"}});
        s1.execute("delete from t2");
        s1.execute("insert into t3 values 1, 2");
        TriggerWhenClauseTest.assertUpdateCount(s2, 2, "insert into u1.t1(x) values 'x', 'y'");
        JDBC.assertSingleValueResultSet(s1.executeQuery("select * from t2 order by x"), "***");
        s1.execute("delete from t2");
        s1.execute("alter table t1 alter column x set data type varchar(200)");
        TriggerWhenClauseTest.assertUpdateCount(s2, 2, "insert into u1.t1(x) values 'true', 'false'");
        JDBC.assertFullResultSet(s1.executeQuery("select * from t2 order by x"), new String[][]{{"***"}, {"true"}});
        s1.execute("delete from t2");
        s1.execute("revoke insert on table t1 from u2 ");
        TriggerWhenClauseTest.assertStatementError(NO_TABLE_PERMISSION, s2, "insert into u1.t1(x) values 'abc'");
        TriggerWhenClauseTest.assertUpdateCount(s1, 2, "insert into t1(x) values 'true', 'false'");
        JDBC.assertFullResultSet(s1.executeQuery("select * from t2 order by x"), new String[][]{{"***"}, {"true"}});
        s1.execute("delete from t2");
        s2.execute("create table t(x varchar(200))");
        TriggerWhenClauseTest.assertStatementError(NOT_AUTHORIZED, s2, "create trigger tr after insert on t referencing new as new for each row when (u1.is_true(new.x)) values 1");
        s1.execute("grant execute on function is_true to u2");
        s2.execute("create trigger tr after insert on t referencing new as new for each row when (u1.is_true(new.x)) values 1");
        TriggerWhenClauseTest.assertUpdateCount(s2, 3, "insert into t values 'ab', 'cd', 'ef'");
        TriggerWhenClauseTest.assertStatementError(HAS_DEPENDENTS, s1, "revoke execute on function is_true from u2 restrict");
        s1.close();
        s2.close();
        c2.setAutoCommit(false);
        JDBC.dropSchema(c2.getMetaData(), "U2");
        c1.setAutoCommit(false);
        JDBC.dropSchema(c1.getMetaData(), "U1");
    }

    public void testRuntimeException() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create function f(x varchar(10)) returns int deterministic language java parameter style java external name 'java.lang.Integer.parseInt' no sql");
        s.execute("create table t1(x varchar(10))");
        s.execute("create table t2(x varchar(10))");
        s.execute("create trigger tr after insert on t1 referencing new as new for each row when (f(new.x) < 100) insert into t2 values new.x");
        TriggerWhenClauseTest.assertStatementError(new String[]{USER_EXCEPTION, JAVA_EXCEPTION}, s, "insert into t1 values '1', '2', 'hello', '3', '121'");
        this.assertTableRowCount("T1", 0);
        this.assertTableRowCount("T2", 0);
        TriggerWhenClauseTest.assertUpdateCount(s, 4, "insert into t1 values '1', '2', '3', '121'");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by x"), new String[][]{{"1"}, {"2"}, {"3"}});
    }

    public void testScalarSubquery() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int)");
        s.execute("create table t3(x int)");
        s.execute("insert into t3 values 0,1,2,2");
        s.execute("create trigger tr1 after insert on t1 referencing new as new for each row when ((select x > 0 from t3 where x = new.x)) insert into t2 values 1");
        s.execute("insert into t1 values 42");
        this.assertTableRowCount("T2", 0);
        s.execute("insert into t1 values 0");
        this.assertTableRowCount("T2", 0);
        s.execute("insert into t1 values 1");
        this.assertTableRowCount("T2", 1);
        TriggerWhenClauseTest.assertStatementError(NON_SCALAR_QUERY, s, "insert into t1 values 2");
        this.assertTableRowCount("T2", 1);
    }

    public void testCurrentUser() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x varchar(10))");
        s.execute("create trigger tr01 after insert on t1 when (current_user = 'U2') insert into t2 values 'TR01'");
        s.execute("create trigger tr02 after insert on t1 when (current_user <> 'U2') insert into t2 values 'TR02'");
        s.execute("grant insert on t1 to u2");
        this.commit();
        s.execute("insert into t1 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "TR02");
        this.rollback();
        Connection c2 = this.openUserConnection("u2");
        c2.setAutoCommit(true);
        Statement s2 = c2.createStatement();
        s2.execute("insert into " + JDBC.escape(TestConfiguration.getCurrent().getUserName(), "T1") + " values 1");
        s2.close();
        c2.close();
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2"), "TR01");
        this.dropTable("T1");
        this.dropTable("T2");
        this.commit();
    }

    public void testRecursiveTrigger() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t(x int)");
        s.execute("create trigger tr1 after insert on t referencing new as new for each row when (new.x > 0) insert into t values new.x - 1");
        s.execute("insert into t values 15, 1, 2");
        String[][] expectedRows = new String[][]{{"0"}, {"0"}, {"0"}, {"1"}, {"1"}, {"1"}, {"2"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {"10"}, {"11"}, {"12"}, {"13"}, {"14"}, {"15"}};
        JDBC.assertFullResultSet(s.executeQuery("select * from t order by x"), expectedRows);
        TriggerWhenClauseTest.assertStatementError(TRIGGER_RECURSION, s, "insert into t values 16");
        JDBC.assertFullResultSet(s.executeQuery("select * from t order by x"), expectedRows);
    }

    public void testVeryLongWhenClause() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(x int)");
        StringBuilder sb = new StringBuilder("(values /* a very");
        for (int i = 0; i < 10000; ++i) {
            sb.append(", very");
        }
        sb.append(" long comment */ true)");
        String when = sb.toString();
        TriggerWhenClauseTest.assertTrue((when.length() > 32700 ? 1 : 0) != 0);
        s.execute("create trigger very_long_trigger after insert on t1 when (" + when + ") insert into t2 values 1");
        JDBC.assertSingleValueResultSet(s.executeQuery("select whenclausetext from sys.systriggers where triggername = 'VERY_LONG_TRIGGER'"), when);
        s.execute("insert into t1 values 1");
        this.assertTableRowCount("T1", 1);
        this.assertTableRowCount("T2", 1);
    }

    public void testFunctionReadsSQLData() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create function f(x varchar(10)) returns boolean language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".tableIsEmpty' reads sql data");
        s.execute("create table t1(x varchar(10))");
        s.execute("create table t2(x varchar(10))");
        s.execute("create table t3(x int)");
        s.execute("create table t4(x int)");
        s.execute("insert into t3 values 1");
        s.execute("create trigger tr after insert on t1 referencing new as new for each row when (f(new.x)) insert into t2 values new.x");
        s.execute("insert into t1 values 'T3', 'T4', 'T3', 'T4', 'T3', 'T4'");
        JDBC.assertFullResultSet(s.executeQuery("select x, count(x) from t2 group by x"), new String[][]{{"T4", "3"}});
    }

    public static boolean tableIsEmpty(String table) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from " + JDBC.escape(table));
        boolean empty = !rs.next();
        rs.close();
        s.close();
        c.close();
        return empty;
    }

    public void testRoutineModifiesSQLData() throws SQLException {
        this.assertCompileError(SYNTAX_ERROR, "create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs' modifies sql data");
        Statement s = this.createStatement();
        s.execute("create procedure p(i int) language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".intProcedure' no sql");
        s.execute("create table t(x int)");
        this.assertCompileError(SYNTAX_ERROR, "create trigger tr after insert on t when (call p(1)) values 1");
        this.assertCompileError(PROC_USED_AS_FUNC, "create trigger tr after insert on t when (p(1)) values 1");
    }

    public void testAggregates() throws SQLException {
        Statement s = this.createStatement();
        s.execute("create table t1(x int)");
        s.execute("create table t2(y varchar(10))");
        s.execute("create derby aggregate mode_int for int external name '" + ModeAggregate.class.getName() + "'");
        s.execute("create trigger tr1 after insert on t1 referencing new table as new when ((select max(x) from new) between 0 and 3) insert into t2 values 'tr1'");
        s.execute("create trigger tr2 after insert on t1 referencing new table as new when ((select count(x) from new) between 0 and 3) insert into t2 values 'tr2'");
        s.execute("create trigger tr3 after insert on t1 referencing new table as new when ((select mode_int(x) from new) between 0 and 3) insert into t2 values 'tr3'");
        s.execute("insert into t1 values 2, 4, 4");
        JDBC.assertSingleValueResultSet(s.executeQuery("select * from t2 order by y"), "tr2");
        s.execute("delete from t2");
        s.execute("insert into t1 values 2, 2, 3, 1, 0");
        JDBC.assertFullResultSet(s.executeQuery("select * from t2 order by y"), new String[][]{{"tr1"}, {"tr3"}});
    }
}

