/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

public class RoleClosureIteratorImpl
implements RoleClosureIterator {
    private final boolean inverse;
    private HashMap<String, Object> seenSoFar;
    private HashMap<String, List<RoleGrantDescriptor>> graph;
    private List<RoleGrantDescriptor> lifo;
    private Iterator<RoleGrantDescriptor> currNodeIter;
    private DataDictionaryImpl dd;
    private TransactionController tc;
    private String root;
    private boolean initial;

    RoleClosureIteratorImpl(String root, boolean inverse, DataDictionaryImpl dd, TransactionController tc) {
        this.inverse = inverse;
        this.graph = null;
        this.root = root;
        this.dd = dd;
        this.tc = tc;
        this.seenSoFar = new HashMap();
        this.lifo = new ArrayList<RoleGrantDescriptor>();
        RoleGrantDescriptor dummy = new RoleGrantDescriptor(null, null, inverse ? root : null, inverse ? null : root, null, false, false);
        ArrayList<RoleGrantDescriptor> dummyList = new ArrayList<RoleGrantDescriptor>();
        dummyList.add(dummy);
        this.currNodeIter = dummyList.iterator();
        this.initial = true;
    }

    @Override
    public String next() throws StandardException {
        if (this.initial) {
            this.initial = false;
            this.seenSoFar.put(this.root, null);
            return this.root;
        }
        if (this.graph == null) {
            this.graph = this.dd.getRoleGrantGraph(this.tc, this.inverse);
            List<RoleGrantDescriptor> outArcs = this.graph.get(this.root);
            if (outArcs != null) {
                this.currNodeIter = outArcs.iterator();
            }
        }
        RoleGrantDescriptor result = null;
        while (result == null) {
            while (this.currNodeIter.hasNext()) {
                RoleGrantDescriptor r = this.currNodeIter.next();
                if (this.seenSoFar.containsKey(this.inverse ? r.getRoleName() : r.getGrantee())) continue;
                this.lifo.add(r);
                result = r;
                break;
            }
            if (result != null) continue;
            RoleGrantDescriptor newNode = null;
            this.currNodeIter = null;
            while (this.lifo.size() > 0 && this.currNodeIter == null) {
                newNode = this.lifo.remove(this.lifo.size() - 1);
                List<RoleGrantDescriptor> outArcs = this.graph.get(this.inverse ? newNode.getRoleName() : newNode.getGrantee());
                if (outArcs == null) continue;
                this.currNodeIter = outArcs.iterator();
            }
            if (this.currNodeIter != null) continue;
            this.currNodeIter = null;
            break;
        }
        if (result != null) {
            String role = this.inverse ? result.getRoleName() : result.getGrantee();
            this.seenSoFar.put(role, null);
            return role;
        }
        return null;
    }
}

