/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

class DropIndexConstantAction
extends IndexConstantAction {
    private String fullIndexName;
    private long tableConglomerateId;

    DropIndexConstantAction(String fullIndexName, String indexName, String tableName, String schemaName, UUID tableId, long tableConglomerateId) {
        super(tableId, indexName, tableName, schemaName);
        this.fullIndexName = fullIndexName;
        this.tableConglomerateId = tableConglomerateId;
    }

    public String toString() {
        return "DROP INDEX " + this.fullIndexName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        if (this.tableConglomerateId == 0L) {
            td = dd.getTableDescriptor(this.tableId);
            if (td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = td.getHeapConglomerateId();
        }
        this.lockTableForDDL(tc, this.tableConglomerateId, true);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.indexName, sd, true);
        if (cd == null) {
            throw StandardException.newException("X0X99.S", this.fullIndexName);
        }
        this.dropConglomerate(cd, td, activation, lcc);
    }
}

