/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.PooledConnection;
import junit.framework.Test;
import org.apache.derby.jdbc.ClientConnectionPoolDataSourceInterface;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientConnectionPoolDataSourceTest
extends BaseJDBCTestCase {
    public ClientConnectionPoolDataSourceTest(String name) {
        super(name);
    }

    public void testMaxStatementsProperty() throws Exception {
        ClientConnectionPoolDataSourceInterface cDs;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientConnectionPoolDataSource");
            cDs = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientConnectionPoolDataSource40");
            cDs = (ClientConnectionPoolDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        ClientConnectionPoolDataSourceTest.assertEquals((String)"Unexpected default value", (int)0, (int)cDs.getMaxStatements());
        cDs.setMaxStatements(25);
        ClientConnectionPoolDataSourceTest.assertEquals((String)"New value not set", (int)25, (int)cDs.getMaxStatements());
        try {
            cDs.setMaxStatements(-99);
            ClientConnectionPoolDataSourceTest.fail((String)("Negative values should not be allowed: " + cDs.getMaxStatements()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        cDs.setMaxStatements(0);
        ClientConnectionPoolDataSourceTest.assertEquals((String)"New value not set", (int)0, (int)cDs.getMaxStatements());
    }

    public void testGetConnectionNoStatementPooling() throws SQLException {
        ClientConnectionPoolDataSourceInterface cDs = (ClientConnectionPoolDataSourceInterface)J2EEDataSource.getConnectionPoolDataSource();
        cDs.setMaxStatements(0);
        ClientConnectionPoolDataSourceTest.assertEquals((int)0, (int)cDs.getMaxStatements());
        this.verifyConnection(cDs);
    }

    public void testGetConnectionWithStatementPooling() throws SQLException {
        ClientConnectionPoolDataSourceInterface cDs = (ClientConnectionPoolDataSourceInterface)J2EEDataSource.getConnectionPoolDataSource();
        cDs.setMaxStatements(27);
        ClientConnectionPoolDataSourceTest.assertTrue((cDs.getMaxStatements() > 0 ? 1 : 0) != 0);
        this.verifyConnection(cDs);
    }

    private void verifyConnection(ClientConnectionPoolDataSourceInterface cDs) throws SQLException {
        J2EEDataSource.setBeanProperty(cDs, "createDatabase", "create");
        PooledConnection pc = cDs.getPooledConnection();
        Connection con = pc.getConnection();
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select * from sys.systables");
        JDBC.assertDrainResultsHasData(rs);
        PreparedStatement ps1 = con.prepareStatement("values 31");
        JDBC.assertSingleValueResultSet(ps1.executeQuery(), "31");
        ps1.close();
        PreparedStatement ps2 = con.prepareStatement("values 31");
        ClientConnectionPoolDataSourceTest.assertNotSame((Object)ps1, (Object)ps2);
        JDBC.assertSingleValueResultSet(ps2.executeQuery(), "31");
        stmt.close();
        ps2.close();
        con.close();
        pc.close();
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(ClientConnectionPoolDataSourceTest.class);
    }
}

