/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.WarehouseVTI;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class VTITest
extends BaseJDBCTestCase {
    private final String tableName;

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("VTITest");
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest((Test)new VTITest("bulkInsertVtiTest", "WAREHOUSE"));
            suite.addTest((Test)new VTITest("bulkInsertVtiTest", "test\"'table"));
        }
        return suite;
    }

    private VTITest(String name, String tableName) {
        super(name);
        this.tableName = tableName;
    }

    protected void setUp() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("CREATE TABLE " + JDBC.escape(this.tableName) + "(id int)");
        stmt.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("DROP TABLE " + JDBC.escape(this.tableName));
        stmt.close();
        super.tearDown();
    }

    public void bulkInsertVtiTest() throws SQLException {
        int expectedRows = 10;
        CallableStatement cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BULK_INSERT(?, ?, ?, ?)");
        cs.setString(1, "APP");
        cs.setString(2, this.tableName);
        cs.setString(3, WarehouseVTI.class.getName());
        cs.setInt(4, expectedRows);
        cs.execute();
        ResultSet rs = this.createStatement().executeQuery("SELECT 1 FROM " + JDBC.escape(this.tableName));
        JDBC.assertDrainResults(rs, expectedRows);
    }
}

