/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public abstract class ImportExportBaseTest
extends BaseJDBCTestCase {
    public ImportExportBaseTest(String name) {
        super(name);
    }

    protected void doExportTable(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset) throws SQLException {
        String expsql = "call SYSCS_UTIL.SYSCS_EXPORT_TABLE (? , ? , ? , ?, ? , ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.execute();
        ps.close();
    }

    protected void doExportQuery(String query, String fileName, String colDel, String charDel, String codeset) throws SQLException {
        String expsql = "call SYSCS_UTIL.SYSCS_EXPORT_QUERY(? , ? , ? , ?, ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, query);
        ps.setString(2, fileName);
        ps.setString(3, colDel);
        ps.setString(4, charDel);
        ps.setString(5, codeset);
        ps.execute();
        ps.close();
    }

    protected void doImportTable(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.execute();
        ps.close();
    }

    protected void doImportData(String schemaName, String tableName, String insertCols, String colIndexes, String fileName, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_DATA(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, insertCols);
        ps.setString(4, colIndexes);
        ps.setString(5, fileName);
        ps.setString(6, colDel);
        ps.setString(7, charDel);
        ps.setString(8, codeset);
        ps.setInt(9, replace);
        ps.execute();
        ps.close();
    }

    protected void doExportTableLobsToExtFile(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset, String lobsFileName) throws SQLException {
        String expsql = "call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(? , ? , ? , ?, ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setString(7, lobsFileName);
        ps.execute();
        ps.close();
    }

    protected void doExportQueryLobsToExtFile(String query, String fileName, String colDel, String charDel, String codeset, String lobsFileName) throws SQLException {
        String expsql = "call SYSCS_UTIL.SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE(? , ? , ? , ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(expsql);
        ps.setString(1, query);
        ps.setString(2, fileName);
        ps.setString(3, colDel);
        ps.setString(4, charDel);
        ps.setString(5, codeset);
        ps.setString(6, lobsFileName);
        ps.execute();
        ps.close();
    }

    protected void doImportTableLobsFromExtFile(String schemaName, String tableName, String fileName, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE(?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, fileName);
        ps.setString(4, colDel);
        ps.setString(5, charDel);
        ps.setString(6, codeset);
        ps.setInt(7, replace);
        ps.execute();
        ps.close();
    }

    protected void doImportDataLobsFromExtFile(String schemaName, String tableName, String insertCols, String colIndexes, String fileName, String colDel, String charDel, String codeset, int replace) throws SQLException {
        String impsql = "call SYSCS_UTIL.SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = this.prepareStatement(impsql);
        ps.setString(1, schemaName);
        ps.setString(2, tableName);
        ps.setString(3, insertCols);
        ps.setString(4, colIndexes);
        ps.setString(5, fileName);
        ps.setString(6, colDel);
        ps.setString(7, charDel);
        ps.setString(8, codeset);
        ps.setInt(9, replace);
        ps.execute();
        ps.close();
    }
}

