/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.TorqueSchemaInheritance;
import org.apache.torque.templates.TorqueSchemaJavaType;
import org.apache.torque.templates.transformer.SchemaTypeHelper;
import org.apache.torque.templates.transformer.om.ColumnAttributeName;
import org.apache.torque.templates.transformer.om.FieldHelper;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.OMInheritanceTransformer;
import org.apache.torque.templates.transformer.om.TableAttributeName;
import org.apache.torque.templates.typemapping.JavaType;
import org.apache.torque.templates.typemapping.ResultSetGetter;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;
import org.apache.torque.templates.typemapping.TypeMap;

public class OMColumnTransformer {
    private static Camelbacker javaNameCamelbacker = new Camelbacker();
    private static OMInheritanceTransformer inheritanceTransformer = new OMInheritanceTransformer();
    private static final Set<String> RESERVED_CONSTANT_NAMES;
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    static final String CURRENT_DATE = "CURRENT_DATE";
    static final String CURRENT_TIME = "CURRENT_TIME";
    static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    static final String GET_DEFAULT_DATE_METHOD_NAME = "getCurrentDate";
    static final String GET_DEFAULT_TIME_METHOD_NAME = "getCurrentTime";
    static final String GET_DEFAULT_TIMESTAMP_METHOD_NAME = "getCurrentTimestamp";
    private static WrapReservedJavaWords reservedJavaWordsWrapper;

    public void transform(SourceElement columnElement, ControllerState controllerState, int columnPosition) throws SourceTransformerException {
        this.checkElementName(columnElement);
        this.checkColumnNameExists(columnElement);
        this.setJavaTypeAttribute(columnElement);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.POSITION, (Object)columnPosition);
        this.setAttributeDefaultValues(columnElement);
        SchemaType schemaType = SchemaTypeHelper.getSchemaType(columnElement, controllerState);
        columnElement.setAttribute("schemaType", (Object)schemaType);
        this.setDomainAttributes(columnElement, controllerState);
        JavaType fieldJavaType = this.getFieldJavaType(columnElement, schemaType);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)fieldJavaType.getFullClassName());
        JavaType fieldJavaObjectType = TypeMap.getJavaObjectType(schemaType);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.FIELD_OBJECT_TYPE, (Object)fieldJavaObjectType.getFullClassName());
        this.setPrimitiveTypeAttribute(columnElement, fieldJavaType);
        this.setNumberTypeAttribute(columnElement, fieldJavaType);
        this.setJavaNameAttribute(columnElement);
        this.setFieldNameAttribute(columnElement);
        this.setPeerColumnNameAttribute(columnElement);
        this.setQualifiedColumnNameAttribute(columnElement);
        this.setGetterNameAttribute(columnElement, fieldJavaType, controllerState);
        this.setSetterNameAttribute(columnElement);
        this.setAccessModifierAttributes(columnElement);
        this.setDefaultValueAttribute(columnElement, fieldJavaType, controllerState);
        this.setUseDatabaseDefaultValueAttribute(columnElement);
        this.setResultSetGetterAttribute(columnElement, schemaType);
        this.setSampleObjectAttribute(columnElement, schemaType);
        for (SourceElement inheritanceElement : columnElement.getChildren(TorqueSchemaElementName.INHERITANCE.getName())) {
            inheritanceTransformer.transform(inheritanceElement, controllerState);
        }
    }

    protected void setJavaTypeAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE) != null) {
            return;
        }
        SourceElement databaseElement = columnElement.getParent().getParent();
        String defaultJavaType = (String)databaseElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT_JAVA_TYPE);
        if (defaultJavaType != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE, (Object)defaultJavaType);
        }
    }

    protected void setAttributeDefaultValues(SourceElement columnElement) {
        Object primaryKey;
        Object required;
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT) == null) {
            String idMethod = (String)columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD);
            if (!"none".equals(idMethod)) {
                columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT, (Object)Boolean.TRUE.toString());
            } else {
                columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT, (Object)Boolean.FALSE.toString());
            }
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED, (Object)Boolean.FALSE.toString());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE, (Object)Boolean.FALSE.toString());
        }
        if ((required = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.REQUIRED)) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.REQUIRED, (Object)Boolean.FALSE.toString());
        }
        if ((primaryKey = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PRIMARY_KEY)) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.PRIMARY_KEY, (Object)Boolean.FALSE.toString());
        }
    }

    protected void setDomainAttributes(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        SqlType domain = SchemaTypeHelper.getDomain(columnElement, controllerState);
        if (domain == null) {
            return;
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.TYPE) == null && domain.getSqlTypeName() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.TYPE, (Object)domain.getSqlTypeName());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT) == null && domain.getDefaultValue() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT, (Object)domain.getDefaultValue());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE) == null && domain.getSize() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE, (Object)domain.getSize());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE) == null && domain.getScale() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE, (Object)domain.getScale());
        }
    }

    protected void setAccessModifierAttributes(SourceElement columnElement) {
        boolean isProtected = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED));
        String accessModifier = isProtected ? "protected" : "public";
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_ACCESS_MODIFIER, (Object)accessModifier);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_ACCESS_MODIFIER, (Object)accessModifier);
    }

    protected JavaType getFieldJavaType(SourceElement columnElement, SchemaType schemaType) throws SourceTransformerException {
        JavaType result;
        String javaType = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE);
        if (TorqueSchemaJavaType.OBJECT.getValue().equals(javaType)) {
            result = TypeMap.getJavaObjectType(schemaType);
        } else if (TorqueSchemaJavaType.PRIMITIVE.getValue().equals(javaType) || javaType == null) {
            result = TypeMap.getJavaPrimitiveType(schemaType);
        } else {
            String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            throw new SourceTransformerException("Unknown javaType " + javaType + " in column " + columnName);
        }
        return result;
    }

    protected void checkElementName(SourceElement columnElement) {
        if (!TorqueSchemaElementName.COLUMN.getName().equals(columnElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + columnElement.getName());
        }
    }

    protected void checkColumnNameExists(SourceElement columnElement) throws SourceTransformerException {
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        if (columnName == null) {
            throw new SourceTransformerException("The attribute " + TorqueSchemaAttributeName.NAME.getName() + " on element " + columnElement.getName() + " is null");
        }
    }

    protected void setJavaNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME) != null) {
            return;
        }
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String javaName = javaNameCamelbacker.process(columnName);
        columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME, (Object)javaName);
    }

    protected void setFieldNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME) != null) {
            return;
        }
        String javaName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        String fieldName = StringUtils.uncapitalize((String)javaName);
        fieldName = reservedJavaWordsWrapper.process(fieldName);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)fieldName);
    }

    protected void setPeerColumnNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.PEER_COLUMN_NAME) != null) {
            return;
        }
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String peerColumnName = columnName.toUpperCase();
        if (RESERVED_CONSTANT_NAMES.contains(peerColumnName)) {
            peerColumnName = "_" + peerColumnName;
        }
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.PEER_COLUMN_NAME, (Object)peerColumnName);
    }

    protected void setQualifiedColumnNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.QUALIFIED_COLUMN_NAME) != null) {
            return;
        }
        String tableName = (String)columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String qualifiedColumnName = tableName + "." + columnName;
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.QUALIFIED_COLUMN_NAME, (Object)qualifiedColumnName);
    }

    protected void setGetterNameAttribute(SourceElement columnElement, JavaType javaType, ControllerState controllerState) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME) != null) {
            return;
        }
        String fieldName = (String)columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
        String getterName = FieldHelper.getGetterName(fieldName, javaType.getFullClassName(), controllerState);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
    }

    protected void setSetterNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME) != null) {
            return;
        }
        String fieldName = (String)columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
        String setterName = FieldHelper.getSetterName(fieldName);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
    }

    protected void setPrimitiveTypeAttribute(SourceElement columnElement, JavaType javaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.PRIMITIVE_TYPE) != null) {
            return;
        }
        boolean primitiveFieldType = javaType.isPrimitive();
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.PRIMITIVE_TYPE, (Object)Boolean.toString(primitiveFieldType));
    }

    protected void setNumberTypeAttribute(SourceElement columnElement, JavaType javaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.NUMBER_TYPE) != null) {
            return;
        }
        boolean numberFieldType = javaType.isNumber();
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.NUMBER_TYPE, (Object)Boolean.toString(numberFieldType));
    }

    protected void setDefaultValueAttribute(SourceElement columnElement, JavaType javaType, ControllerState controllerState) throws SourceTransformerException {
        String fieldDefaultValue;
        if (TorqueSchemaInheritance.SINGLE.getValue().equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE)) && columnElement.getChildren((SourceElementName)TorqueSchemaElementName.INHERITANCE).isEmpty()) {
            columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"getClass().getName()");
            return;
        }
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE) != null) {
            return;
        }
        String defaultAttributeValue = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT);
        if (defaultAttributeValue != null) {
            boolean useDatabaseDefaultValue = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE));
            fieldDefaultValue = this.getDefaultValueWithDefaultSet(javaType, defaultAttributeValue, useDatabaseDefaultValue, columnElement);
        } else {
            fieldDefaultValue = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.VERSION)) ? controllerState.getStringOption((OptionName)TemplateOptionName.OM_OPTIMISTIC_LOCKING_DEFAULT_VALUE) : this.getDefaultValueWithoutDefaultSet(javaType);
        }
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)fieldDefaultValue);
    }

    protected String getDefaultValueWithDefaultSet(JavaType javaType, String defaultValue, boolean useDatabaseDefaultValue, SourceElement columnElement) throws SourceTransformerException {
        String fieldDefaultValue;
        boolean primitiveFieldType = javaType.isPrimitive();
        if (JavaType.BOOLEAN_PRIMITIVE == javaType) {
            fieldDefaultValue = "Y".equals(defaultValue) || "1".equals(defaultValue) || "true".equalsIgnoreCase(defaultValue) ? "true" : "false";
        } else if (JavaType.BOOLEAN_OBJECT == javaType) {
            fieldDefaultValue = "Y".equals(defaultValue) || "1".equals(defaultValue) || "true".equalsIgnoreCase(defaultValue) ? "Boolean.TRUE" : "Boolean.FALSE";
        } else if (JavaType.STRING == javaType) {
            fieldDefaultValue = "\"" + defaultValue + "\"";
        } else if (JavaType.SHORT_OBJECT == javaType) {
            fieldDefaultValue = "Short.valueOf(\"" + defaultValue + "\")";
        } else if (JavaType.BYTE_OBJECT == javaType) {
            fieldDefaultValue = "Byte.valueOf(\"" + defaultValue + "\")";
        } else if (JavaType.INTEGER_OBJECT == javaType) {
            fieldDefaultValue = "Integer.valueOf(" + defaultValue + ")";
        } else if (JavaType.LONG_OBJECT == javaType) {
            fieldDefaultValue = "Long.valueOf(" + defaultValue + "L)";
        } else if (JavaType.DATE == javaType) {
            if (CURRENT_DATE.equalsIgnoreCase(defaultValue) || CURRENT_TIME.equalsIgnoreCase(defaultValue) || CURRENT_TIMESTAMP.equalsIgnoreCase(defaultValue)) {
                if (useDatabaseDefaultValue) {
                    fieldDefaultValue = "null";
                } else if (CURRENT_DATE.equalsIgnoreCase(defaultValue)) {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME).toString() : GET_DEFAULT_DATE_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                } else if (CURRENT_TIME.equalsIgnoreCase(defaultValue)) {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME).toString() : GET_DEFAULT_TIME_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                } else {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME).toString() : GET_DEFAULT_TIMESTAMP_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                }
            } else {
                fieldDefaultValue = useDatabaseDefaultValue ? "null" : "new Date(" + OMColumnTransformer.getDefaultValueAsDate(defaultValue).getTime() + "L)";
            }
        } else {
            fieldDefaultValue = primitiveFieldType ? defaultValue : "new " + javaType.getFullClassName() + "(" + defaultValue + ")";
        }
        return fieldDefaultValue;
    }

    public static Date getDefaultValueAsDate(String defaultValue) throws SourceTransformerException {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat.parse(defaultValue);
        }
        catch (ParseException e) {
            throw new SourceTransformerException("The default value " + defaultValue + " does not match the format String " + DEFAULT_DATE_FORMAT + " for date values");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getDefaultValueWithoutDefaultSet(JavaType javaType) throws SourceTransformerException {
        boolean primitiveFieldType = javaType.isPrimitive();
        if (!primitiveFieldType) return "null";
        if (JavaType.BOOLEAN_PRIMITIVE == javaType) {
            return "false";
        }
        if (JavaType.BYTE_PRIMITIVE == javaType) {
            return "(byte) 0";
        }
        if (JavaType.SHORT_PRIMITIVE == javaType) {
            return "(short) 0";
        }
        if (JavaType.INTEGER_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.LONG_PRIMITIVE == javaType) {
            return "0L";
        }
        if (JavaType.FLOAT_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.DOUBLE_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.CHAR_PRIMITIVE != javaType) throw new SourceTransformerException("unknown primitive type" + (Object)((Object)javaType));
        return "'\u0000'";
    }

    protected void setUseDatabaseDefaultValueAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE) != null) {
            return;
        }
        columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE, (Object)Boolean.toString(false));
    }

    protected void setResultSetGetterAttribute(SourceElement columnElement, SchemaType schemaType) {
        ResultSetGetter resultSetGetter = null;
        Object originalValue = columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.RESULT_SET_GETTER);
        if (originalValue != null) {
            if (originalValue instanceof String) {
                resultSetGetter = ResultSetGetter.getByMethodName((String)originalValue);
            }
        } else {
            resultSetGetter = TypeMap.getResultSetGetter(schemaType);
        }
        if (resultSetGetter != null) {
            columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.RESULT_SET_GETTER, (Object)resultSetGetter);
        }
    }

    protected void setSampleObjectAttribute(SourceElement columnElement, SchemaType schemaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.SAMPLE_OBJECT) != null) {
            return;
        }
        String sampleObject = TypeMap.getJavaObject(schemaType);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.SAMPLE_OBJECT, (Object)sampleObject);
    }

    static {
        reservedJavaWordsWrapper = new WrapReservedJavaWords();
        HashSet<String> reservedConstantNames = new HashSet<String>();
        reservedConstantNames.add("DATABASE");
        reservedConstantNames.add("TABLE_NAME");
        reservedConstantNames.add("TABLE");
        RESERVED_CONSTANT_NAMES = Collections.unmodifiableSet(reservedConstantNames);
    }
}

