/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.partialbean.impl;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.literal.DefaultLiteral;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.core.util.BeanUtils;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.bean.BeanBuilder;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.apache.deltaspike.core.util.metadata.builder.ContextualLifecycle;
import org.apache.deltaspike.partialbean.api.PartialBeanBinding;
import org.apache.deltaspike.partialbean.impl.DeltaSpikePartialProducerLifecycle;
import org.apache.deltaspike.partialbean.impl.PartialBeanDescriptor;
import org.apache.deltaspike.partialbean.impl.PartialBeanProxyFactory;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyContextualLifecycle;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;

public class PartialBeanBindingExtension
implements Extension,
Deactivatable {
    private final Map<Class<? extends Annotation>, PartialBeanDescriptor> descriptors = new HashMap<Class<? extends Annotation>, PartialBeanDescriptor>();
    private Boolean isActivated = true;
    private IllegalStateException definitionError;

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public <X> void findInvocationHandlerBindings(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        if (!this.isActivated.booleanValue() || this.definitionError != null) {
            return;
        }
        Class beanClass = pat.getAnnotatedType().getJavaClass();
        Class<Annotation> bindingClass = this.extractBindingClass(pat);
        if (bindingClass == null) {
            return;
        }
        if (beanClass.isInterface() || Modifier.isAbstract(beanClass.getModifiers())) {
            pat.veto();
            PartialBeanDescriptor descriptor = this.descriptors.get(bindingClass);
            if (descriptor == null) {
                descriptor = new PartialBeanDescriptor(bindingClass, null, beanClass);
                this.descriptors.put(bindingClass, descriptor);
            } else if (!descriptor.getClasses().contains(beanClass)) {
                descriptor.getClasses().add(beanClass);
            }
        } else if (InvocationHandler.class.isAssignableFrom(beanClass)) {
            PartialBeanDescriptor descriptor = this.descriptors.get(bindingClass);
            if (descriptor == null) {
                descriptor = new PartialBeanDescriptor(bindingClass, beanClass);
                this.descriptors.put(bindingClass, descriptor);
            } else if (descriptor.getHandler() == null) {
                descriptor.setHandler(beanClass);
            } else if (!descriptor.getHandler().equals(beanClass)) {
                this.definitionError = new IllegalStateException("Multiple handlers found for " + bindingClass.getName() + " (" + descriptor.getHandler().getName() + " and " + beanClass.getName() + ")");
            }
        } else {
            this.definitionError = new IllegalStateException(beanClass.getName() + " is annotated with @" + bindingClass.getName() + " and therefore has to be an abstract class, an interface or an implementation of " + InvocationHandler.class.getName());
        }
    }

    public <X> void createBeans(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.definitionError != null) {
            afterBeanDiscovery.addDefinitionError((Throwable)this.definitionError);
            return;
        }
        for (Map.Entry<Class<? extends Annotation>, PartialBeanDescriptor> entry : this.descriptors.entrySet()) {
            PartialBeanDescriptor descriptor = entry.getValue();
            if (descriptor.getClasses() == null) continue;
            for (Class<?> partialBeanClass : descriptor.getClasses()) {
                Bean<?> partialBean = this.createPartialBean(partialBeanClass, descriptor, afterBeanDiscovery, beanManager);
                if (partialBean == null) continue;
                afterBeanDiscovery.addBean(partialBean);
                List<Bean> partialProducerBeans = this.createPartialProducersDefinedIn(partialBean, afterBeanDiscovery, beanManager);
                for (Bean partialProducerBean : partialProducerBeans) {
                    afterBeanDiscovery.addBean(partialProducerBean);
                }
            }
        }
        this.descriptors.clear();
    }

    protected <T> Bean<T> createPartialBean(Class<T> beanClass, PartialBeanDescriptor descriptor, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (descriptor.getHandler() == null) {
            afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("A class which implements " + InvocationHandler.class.getName() + " and is annotated with @" + descriptor.getBinding().getName() + " is needed as a handler for " + beanClass.getName() + ". See the documentation about @" + PartialBeanBinding.class.getName() + "."));
            return null;
        }
        AnnotatedType annotatedType = new AnnotatedTypeBuilder().readFromType(beanClass).create();
        DeltaSpikeProxyContextualLifecycle lifecycle = new DeltaSpikeProxyContextualLifecycle(beanClass, descriptor.getHandler(), (DeltaSpikeProxyFactory)PartialBeanProxyFactory.getInstance(), beanManager);
        BeanBuilder beanBuilder = new BeanBuilder(beanManager).readFromType(annotatedType).passivationCapable(true).beanLifecycle((ContextualLifecycle)lifecycle);
        return beanBuilder.create();
    }

    protected <X> Class<? extends Annotation> extractBindingClass(ProcessAnnotatedType<X> pat) {
        for (Annotation annotation : pat.getAnnotatedType().getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(PartialBeanBinding.class)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    protected List<Bean> createPartialProducersDefinedIn(Bean partialBean, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Class currentClass = partialBean.getBeanClass();
        return this.createPartialProducersDefinedIn(partialBean, afterBeanDiscovery, beanManager, currentClass);
    }

    private List<Bean> createPartialProducersDefinedIn(Bean partialBean, AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager, Class currentClass) {
        ArrayList<Bean> result = new ArrayList<Bean>();
        while (currentClass != null && !Object.class.getName().equals(currentClass.getName())) {
            for (Class<?> clazz : currentClass.getInterfaces()) {
                if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) continue;
                result.addAll(this.createPartialProducersDefinedIn(partialBean, afterBeanDiscovery, beanManager, clazz));
            }
            for (GenericDeclaration genericDeclaration : currentClass.getDeclaredMethods()) {
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Produces.class)) continue;
                if (((Method)genericDeclaration).getParameterTypes().length > 0) {
                    afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("Producer-methods in partial-beans currently don't support injection-points. Please remove the parameters from " + ((Method)genericDeclaration).toString() + " in " + currentClass.getName()));
                }
                DeltaSpikePartialProducerLifecycle lifecycle = new DeltaSpikePartialProducerLifecycle(partialBean.getBeanClass(), (Method)genericDeclaration);
                Class<? extends Annotation> scopeClass = this.extractScope(((Method)genericDeclaration).getDeclaredAnnotations(), beanManager);
                Class<?> producerResultType = ((Method)genericDeclaration).getReturnType();
                boolean passivationCapable = Serializable.class.isAssignableFrom(producerResultType) || producerResultType.isPrimitive();
                Set<Annotation> qualifiers = this.extractQualifiers(((Method)genericDeclaration).getDeclaredAnnotations(), beanManager);
                BeanBuilder beanBuilder = new BeanBuilder(beanManager).beanClass(producerResultType).types(new Type[]{Object.class, producerResultType}).qualifiers(qualifiers).passivationCapable(passivationCapable).scope(scopeClass).id(this.createPartialProducerId(currentClass, (Method)genericDeclaration, qualifiers)).beanLifecycle(lifecycle);
                result.add(beanBuilder.create());
            }
            currentClass = currentClass.getSuperclass();
        }
        return result;
    }

    private Set<Annotation> extractQualifiers(Annotation[] annotations, BeanManager beanManager) {
        Set result = BeanUtils.getQualifiers((BeanManager)beanManager, (Annotation[][])new Annotation[][]{annotations});
        if (result.isEmpty()) {
            result.add(new DefaultLiteral());
        }
        return result;
    }

    private Class<? extends Annotation> extractScope(Annotation[] annotations, BeanManager beanManager) {
        for (Annotation annotation : annotations) {
            if (!beanManager.isScope(annotation.annotationType())) continue;
            return annotation.annotationType();
        }
        return Dependent.class;
    }

    private String createPartialProducerId(Class currentClass, Method currentMethod, Set<Annotation> qualifiers) {
        int qualifierHashCode = 0;
        for (Annotation qualifier : qualifiers) {
            qualifierHashCode += AnnotationUtils.getQualifierHashCode((Annotation)qualifier);
        }
        return "PartialProducer#" + currentClass.getName() + "#" + currentMethod.getName() + "#" + qualifierHashCode;
    }
}

