/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import java.util.Set;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.AbstractControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponse;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponseFlag;
import org.apache.directory.api.ldap.extras.controls.ad.AdDirSyncResponseImpl;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncResponseContainer;
import org.apache.directory.api.ldap.model.message.Control;

public class AdDirSyncResponseFactory
extends AbstractControlFactory<AdDirSyncResponse> {
    public AdDirSyncResponseFactory(LdapApiService codec) {
        super(codec, "1.2.840.113556.1.4.841");
    }

    public AdDirSyncResponse newControl() {
        return new AdDirSyncResponseImpl();
    }

    public void encodeValue(Asn1Buffer buffer, Control control) {
        AdDirSyncResponse adDirSync = (AdDirSyncResponse)control;
        int start = buffer.getPos();
        BerValue.encodeOctetString((Asn1Buffer)buffer, (byte[])adDirSync.getCookie());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)adDirSync.getMaxReturnLength());
        BerValue.encodeInteger((Asn1Buffer)buffer, (int)AdDirSyncResponseFlag.getBitmask((Set)adDirSync.getFlags()));
        BerValue.encodeSequence((Asn1Buffer)buffer, (int)start);
    }

    public void decodeValue(Control control, byte[] controlBytes) throws DecoderException {
        this.decodeValue(new AdDirSyncResponseContainer(control), control, controlBytes);
    }
}

