/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.model.Graphable;
import org.apache.directory.fortress.core.model.Hier;
import org.apache.directory.fortress.core.model.Relationship;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HierUtil {
    private static final String CLS_NM = HierUtil.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private static final String VERTEX = "Vertex";
    private static final Map<String, ReadWriteLock> synchMap = new HashMap<String, ReadWriteLock>();

    private HierUtil() {
    }

    static void validateRelationship(SimpleDirectedGraph<String, Relationship> graph, String child, String parent, boolean mustExist) throws ValidationException {
        if (child.equalsIgnoreCase(parent)) {
            String error = "validateRelationship child [" + child + "] same as parent [" + parent + "]";
            throw new ValidationException(5057, error);
        }
        Relationship rel = new Relationship(child.toUpperCase(), parent.toUpperCase());
        if (mustExist && !HierUtil.isRelationship(graph, rel)) {
            String error = "validateRelationship child [" + child + "] does not have parent [" + parent + "]";
            throw new ValidationException(5060, error);
        }
        if (!mustExist && HierUtil.isAscendant(child, parent, graph)) {
            String error = "validateRelationship child [" + child + "] already has parent [" + parent + "]";
            throw new ValidationException(5059, error);
        }
        if (!mustExist && HierUtil.isDescedant(parent, child, graph)) {
            String error = "validateRelationship child [" + child + "] is parent of [" + parent + "]";
            throw new ValidationException(5064, error);
        }
    }

    private static SimpleDirectedGraph<String, Relationship> toGraph(Hier hier) {
        LOG.debug("toGraph");
        SimpleDirectedGraph graph = new SimpleDirectedGraph(Relationship.class);
        List<Relationship> edges = hier.getRelationships();
        if (edges != null && edges.size() > 0) {
            for (Relationship edge : edges) {
                String child = edge.getChild();
                String parent = edge.getParent();
                try {
                    graph.addVertex((Object)child);
                    graph.addVertex((Object)parent);
                    graph.addEdge((Object)child, (Object)parent, (Object)edge);
                }
                catch (IllegalArgumentException e) {
                    String error = "toGraph child: " + child + " parent: " + parent + " caught IllegalArgumentException=" + e;
                    LOG.error(error);
                }
                LOG.debug("toGraph child={}, parent={}", (Object)child, (Object)parent);
            }
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addEdge(SimpleDirectedGraph<String, Relationship> graph, Relationship relation) {
        LOG.debug("addEdge");
        SimpleDirectedGraph<String, Relationship> simpleDirectedGraph = graph;
        synchronized (simpleDirectedGraph) {
            graph.addVertex((Object)relation.getChild().toUpperCase());
            graph.addVertex((Object)relation.getParent().toUpperCase());
            graph.addEdge((Object)relation.getChild().toUpperCase(), (Object)relation.getParent().toUpperCase(), (Object)relation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeEdge(SimpleDirectedGraph<String, Relationship> graph, Relationship relation) {
        LOG.debug("removeEdge");
        SimpleDirectedGraph<String, Relationship> simpleDirectedGraph = graph;
        synchronized (simpleDirectedGraph) {
            graph.removeEdge((Object)relation);
        }
    }

    static int numChildren(String name, SimpleDirectedGraph<String, Relationship> graph) {
        HashMap<String, String> vx = new HashMap<String, String>();
        vx.put(VERTEX, name.toUpperCase());
        return HierUtil.numChildren(vx, graph);
    }

    private static boolean isRelationship(SimpleDirectedGraph<String, Relationship> graph, Relationship rel) {
        return graph.containsEdge((Object)rel);
    }

    private static int numChildren(Map<String, String> vertex, SimpleDirectedGraph<String, Relationship> graph) {
        int numChildren = 0;
        try {
            String v = vertex.get(VERTEX);
            if (v == null) {
                return 0;
            }
            LOG.debug("hasChildren [{}]", (Object)v);
            numChildren = graph.inDegreeOf((Object)v);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return numChildren;
    }

    static Set<String> getAscendants(String childName, SimpleDirectedGraph<String, Relationship> graph) {
        HashMap<String, String> vx = new HashMap<String, String>();
        TreeSet<String> parents = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        vx.put(VERTEX, childName.toUpperCase());
        HierUtil.getAscendants(vx, graph, parents);
        return parents;
    }

    private static String getAscendants(Map<String, String> vertex, SimpleDirectedGraph<String, Relationship> graph, Set<String> ascendants) {
        Set edges;
        String v = vertex.get(VERTEX);
        if (v == null) {
            return null;
        }
        if (graph == null) {
            return null;
        }
        LOG.debug("getAscendants [{}]", (Object)v);
        try {
            edges = graph.outgoingEdgesOf((Object)v);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        for (Relationship edge : edges) {
            vertex.put(VERTEX, edge.getParent());
            ascendants.add(edge.getParent());
            v = HierUtil.getAscendants(vertex, graph, ascendants);
        }
        return v;
    }

    static Set<String> getDescendants(String parentName, SimpleDirectedGraph<String, Relationship> graph) {
        HashMap<String, String> vx = new HashMap<String, String>();
        TreeSet<String> children = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        vx.put(VERTEX, parentName.toUpperCase());
        HierUtil.getDescendants(vx, graph, children);
        return children;
    }

    private static boolean isAscendant(String childName, String parentName, SimpleDirectedGraph<String, Relationship> graph) {
        boolean isAscendant = false;
        Set<String> ascendants = HierUtil.getAscendants(childName, graph);
        if (ascendants.contains(parentName)) {
            isAscendant = true;
        }
        return isAscendant;
    }

    private static boolean isDescedant(String childName, String parentName, SimpleDirectedGraph<String, Relationship> graph) {
        boolean isDescendant = false;
        Set<String> descendants = HierUtil.getDescendants(parentName, graph);
        if (descendants.contains(childName)) {
            isDescendant = true;
        }
        return isDescendant;
    }

    private static String getDescendants(Map<String, String> vertex, SimpleDirectedGraph<String, Relationship> graph, Set<String> descendants) {
        Set edges;
        String v = vertex.get(VERTEX);
        if (v == null) {
            return null;
        }
        if (graph == null) {
            return null;
        }
        LOG.debug("getDescendants [{}]", (Object)v);
        try {
            edges = graph.incomingEdgesOf((Object)v);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        for (Relationship edge : edges) {
            vertex.put(VERTEX, edge.getChild());
            descendants.add(edge.getChild());
            v = HierUtil.getDescendants(vertex, graph, descendants);
        }
        return v;
    }

    static Set<String> getChildren(String vertex, SimpleDirectedGraph<String, Relationship> graph) {
        Set edges;
        HashSet<String> descendants = new HashSet<String>();
        if (graph == null) {
            return null;
        }
        LOG.debug("getChildren [{}]", (Object)vertex);
        try {
            edges = graph.incomingEdgesOf((Object)vertex);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        for (Relationship edge : edges) {
            descendants.add(edge.getChild());
        }
        return descendants;
    }

    static Set<String> getAscendants(String childName, String parentName, boolean isInclusive, SimpleDirectedGraph<String, Relationship> graph) {
        HashMap<String, String> vx = new HashMap<String, String>();
        TreeSet<String> parents = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        vx.put(VERTEX, childName.toUpperCase());
        HierUtil.getAscendants(vx, graph, parents, parentName, isInclusive);
        return parents;
    }

    private static String getAscendants(Map<String, String> vertex, SimpleDirectedGraph<String, Relationship> graph, Set<String> parents, String stopName, boolean isInclusive) {
        Set edges;
        String v = vertex.get(VERTEX);
        if (v == null) {
            return null;
        }
        if (graph == null) {
            return null;
        }
        LOG.debug("getAscendants [{}]", (Object)v);
        try {
            edges = graph.outgoingEdgesOf((Object)v);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        for (Relationship edge : edges) {
            if (edge.getParent().equalsIgnoreCase(stopName)) {
                if (!isInclusive) break;
                parents.add(edge.getParent());
                break;
            }
            vertex.put(VERTEX, edge.getParent());
            parents.add(edge.getParent());
            v = HierUtil.getAscendants(vertex, graph, parents, stopName, isInclusive);
        }
        return v;
    }

    static Set<String> getParents(String vertex, SimpleDirectedGraph<String, Relationship> graph) {
        Set edges;
        HashSet<String> parents = new HashSet<String>();
        if (graph == null) {
            return null;
        }
        LOG.debug("getParents [{}]", (Object)vertex);
        try {
            edges = graph.outgoingEdgesOf((Object)vertex);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        for (Relationship edge : edges) {
            parents.add(edge.getParent());
        }
        return parents;
    }

    static Hier loadHier(String contextId, List<Graphable> descendants) {
        Hier hier = new Hier();
        if (CollectionUtils.isNotEmpty(descendants)) {
            hier.setContextId(contextId);
            for (Graphable descendant : descendants) {
                Set<String> parents = descendant.getParents();
                if (!CollectionUtils.isNotEmpty(parents)) continue;
                for (String parent : parents) {
                    Relationship relationship = new Relationship();
                    relationship.setChild(descendant.getName().toUpperCase());
                    relationship.setParent(parent.toUpperCase());
                    hier.setRelationship(relationship);
                }
            }
        }
        return hier;
    }

    static void updateHier(SimpleDirectedGraph<String, Relationship> graph, Relationship relationship, Hier.Op op) throws SecurityException {
        if (op == Hier.Op.ADD) {
            HierUtil.addEdge(graph, relationship);
        } else if (op == Hier.Op.REM) {
            HierUtil.removeEdge(graph, relationship);
        } else {
            throw new SecurityException(5063, CLS_NM + "updateHier Cannot perform hierarchical operation");
        }
    }

    static SimpleDirectedGraph<String, Relationship> buildGraph(Hier hier) {
        LOG.debug("buildGraph is initializing");
        if (hier == null) {
            String error = "buildGraph detected null hier=";
            LOG.error(error);
            return null;
        }
        SimpleDirectedGraph<String, Relationship> graph = HierUtil.toGraph(hier);
        LOG.debug("buildGraph is success");
        return graph;
    }

    static enum Type {
        ROLE,
        ARLE,
        USO,
        PSO;

    }
}

