/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.model;

import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.ConstraintValidator;
import org.apache.directory.fortress.core.util.VUtil;

public class ConstraintUtil {
    private static final ConstraintValidator constraintValidator = VUtil.getConstraintValidator();

    public static void copy(Constraint srcC, Constraint trgC) {
        trgC.setTimeout(srcC.getTimeout());
        if (StringUtils.isNotEmpty((String)srcC.getName())) {
            trgC.setName(srcC.getName());
        }
        if (StringUtils.isNotEmpty((String)srcC.getBeginTime())) {
            trgC.setBeginTime(srcC.getBeginTime());
        }
        if (StringUtils.isNotEmpty((String)srcC.getEndTime())) {
            trgC.setEndTime(srcC.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)srcC.getDayMask())) {
            trgC.setDayMask(srcC.getDayMask());
        }
        if (StringUtils.isNotEmpty((String)srcC.getBeginDate())) {
            trgC.setBeginDate(srcC.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)srcC.getEndDate())) {
            trgC.setEndDate(srcC.getEndDate());
        }
        if (StringUtils.isNotEmpty((String)srcC.getBeginLockDate())) {
            trgC.setBeginLockDate(srcC.getBeginLockDate());
        }
        if (StringUtils.isNotEmpty((String)srcC.getEndLockDate())) {
            trgC.setEndLockDate(srcC.getEndLockDate());
        }
    }

    public static void validate(Constraint c1) throws ValidationException {
        if (c1.getTimeout() != null) {
            constraintValidator.timeout(c1.getTimeout());
        }
        if (StringUtils.isNotEmpty((String)c1.getBeginTime())) {
            constraintValidator.beginTime(c1.getBeginTime());
        }
        if (StringUtils.isNotEmpty((String)c1.getEndTime())) {
            constraintValidator.endTime(c1.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)c1.getBeginDate())) {
            constraintValidator.beginDate(c1.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)c1.getEndDate())) {
            constraintValidator.endDate(c1.getEndDate());
        }
        if (StringUtils.isNotEmpty((String)c1.getDayMask())) {
            constraintValidator.dayMask(c1.getDayMask());
        }
        if (StringUtils.isNotEmpty((String)c1.getBeginLockDate())) {
            constraintValidator.beginDate(c1.getBeginLockDate());
        }
        if (StringUtils.isNotEmpty((String)c1.getEndLockDate())) {
            constraintValidator.endDate(c1.getEndLockDate());
        }
    }

    public static void setConstraint(String inputString, Constraint constraint) {
        StringTokenizer tkn;
        if (StringUtils.isNotEmpty((String)inputString) && (tkn = new StringTokenizer(inputString, Config.getInstance().getDelimiter(), true)).countTokens() > 0) {
            int count = tkn.countTokens();
            int index = 0;
            boolean previousTokenWasDelimiter = false;
            block11: for (int i = 0; i < count; ++i) {
                String szValue = tkn.nextToken();
                if (szValue.equals(Config.getInstance().getDelimiter()) && !previousTokenWasDelimiter) {
                    previousTokenWasDelimiter = true;
                    continue;
                }
                if (szValue.equals(Config.getInstance().getDelimiter())) {
                    previousTokenWasDelimiter = true;
                    ++index;
                    continue;
                }
                previousTokenWasDelimiter = false;
                switch (index++) {
                    case 0: {
                        if (constraint.getName() != null && constraint.getName().length() != 0) continue block11;
                        constraint.setName(szValue);
                        continue block11;
                    }
                    case 1: {
                        constraint.setTimeout(Integer.parseInt(szValue));
                        continue block11;
                    }
                    case 2: {
                        constraint.setBeginTime(szValue);
                        continue block11;
                    }
                    case 3: {
                        constraint.setEndTime(szValue);
                        continue block11;
                    }
                    case 4: {
                        constraint.setBeginDate(szValue);
                        continue block11;
                    }
                    case 5: {
                        constraint.setEndDate(szValue);
                        continue block11;
                    }
                    case 6: {
                        constraint.setBeginLockDate(szValue);
                        continue block11;
                    }
                    case 7: {
                        constraint.setEndLockDate(szValue);
                        continue block11;
                    }
                    case 8: {
                        constraint.setDayMask(szValue);
                    }
                }
            }
        }
    }

    public static String setConstraint(Constraint constraint) {
        String szConstraint = null;
        String delimiter = Config.getInstance().getDelimiter();
        if (constraint != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(constraint.getName());
            sb.append(delimiter);
            if (constraint.getTimeout() != null) {
                sb.append(constraint.getTimeout());
            }
            sb.append(delimiter);
            if (constraint.getBeginTime() != null) {
                sb.append(constraint.getBeginTime());
            }
            sb.append(delimiter);
            if (constraint.getEndTime() != null) {
                sb.append(constraint.getEndTime());
            }
            sb.append(delimiter);
            if (constraint.getBeginDate() != null) {
                sb.append(constraint.getBeginDate());
            }
            sb.append(delimiter);
            if (constraint.getEndDate() != null) {
                sb.append(constraint.getEndDate());
            }
            sb.append(delimiter);
            if (constraint.getBeginLockDate() != null) {
                sb.append(constraint.getBeginLockDate());
            }
            sb.append(delimiter);
            if (constraint.getEndLockDate() != null) {
                sb.append(constraint.getEndLockDate());
            }
            sb.append(delimiter);
            if (constraint.getDayMask() != null) {
                sb.append(constraint.getDayMask());
            }
            szConstraint = sb.toString();
        }
        return szConstraint;
    }

    public static void validateOrCopy(Constraint srcC, Constraint trgC) throws ValidationException {
        if (trgC.getTimeout() != null) {
            srcC.setTimeout(trgC.getTimeout());
        } else if (srcC.getTimeout() != null) {
            trgC.setTimeout(srcC.getTimeout());
        }
        if (StringUtils.isNotEmpty((String)trgC.getBeginTime())) {
            constraintValidator.beginTime(trgC.getBeginTime());
        } else if (StringUtils.isNotEmpty((String)srcC.getBeginTime())) {
            trgC.setBeginTime(srcC.getBeginTime());
        }
        if (StringUtils.isNotEmpty((String)trgC.getEndTime())) {
            constraintValidator.endTime(trgC.getEndTime());
        } else if (StringUtils.isNotEmpty((String)srcC.getEndTime())) {
            trgC.setEndTime(srcC.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)trgC.getBeginDate())) {
            constraintValidator.beginDate(trgC.getBeginDate());
        } else if (StringUtils.isNotEmpty((String)srcC.getBeginDate())) {
            trgC.setBeginDate(srcC.getBeginDate());
        }
        if (StringUtils.isNotEmpty((String)trgC.getEndDate())) {
            constraintValidator.endDate(trgC.getEndDate());
        } else if (StringUtils.isNotEmpty((String)srcC.getEndDate())) {
            trgC.setEndDate(srcC.getEndDate());
        }
        if (StringUtils.isNotEmpty((String)trgC.getDayMask())) {
            constraintValidator.dayMask(trgC.getDayMask());
        } else if (StringUtils.isNotEmpty((String)srcC.getDayMask())) {
            trgC.setDayMask(srcC.getDayMask());
        }
        if (StringUtils.isNotEmpty((String)trgC.getBeginLockDate())) {
            constraintValidator.beginDate(trgC.getBeginLockDate());
        } else if (StringUtils.isNotEmpty((String)srcC.getBeginLockDate())) {
            trgC.setBeginLockDate(srcC.getBeginLockDate());
        }
        if (StringUtils.isNotEmpty((String)trgC.getEndLockDate())) {
            constraintValidator.endDate(trgC.getEndLockDate());
        } else if (StringUtils.isNotEmpty((String)srcC.getEndLockDate())) {
            trgC.setEndLockDate(srcC.getEndLockDate());
        }
    }
}

