/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.Manageable;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AdminMgrImpl;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.rest.AdminMgrRestImpl;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.VUtil;

public final class AdminMgrFactory {
    private static final String CLS_NM = AdminMgrFactory.class.getName();

    public static AdminMgr createInstance() throws SecurityException {
        return AdminMgrFactory.createInstance("HOME");
    }

    public static AdminMgr createInstance(String contextId) throws SecurityException {
        VUtil.assertNotNull(contextId, 101, CLS_NM + ".createInstance");
        String adminClassName = Config.getInstance().getProperty("adminmgr.implementation");
        Manageable adminMgr = StringUtils.isEmpty((CharSequence)adminClassName) ? (Config.getInstance().isRestEnabled() ? new AdminMgrRestImpl() : new AdminMgrImpl()) : (AdminMgr)ClassUtil.createInstance(adminClassName);
        adminMgr.setContextId(contextId);
        return adminMgr;
    }

    public static AdminMgr createInstance(Session adminSess) throws SecurityException {
        return AdminMgrFactory.createInstance("HOME", adminSess);
    }

    public static AdminMgr createInstance(String contextId, Session adminSess) throws SecurityException {
        AdminMgr adminMgr = AdminMgrFactory.createInstance(contextId);
        adminMgr.setAdmin(adminSess);
        return adminMgr;
    }
}

