/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SchemaViewSortingDialog
extends Dialog {
    private Button inFoldersButton;
    private Button mixedButton;
    private Combo sortingCombo;
    private Button ascendingButton;
    private Button descendingButton;

    public SchemaViewSortingDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("SchemaViewSortingDialog.ViewSorting"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group groupingGroup = new Group(composite, 0);
        groupingGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        groupingGroup.setText(Messages.getString("SchemaViewSortingDialog.Grouping"));
        groupingGroup.setLayout((Layout)new GridLayout());
        this.inFoldersButton = new Button((Composite)groupingGroup, 16);
        this.inFoldersButton.setText(Messages.getString("SchemaViewSortingDialog.GroupTypesAndClasses"));
        this.inFoldersButton.setEnabled(true);
        this.mixedButton = new Button((Composite)groupingGroup, 16);
        this.mixedButton.setText(Messages.getString("SchemaViewSortingDialog.Mixed"));
        this.mixedButton.setEnabled(true);
        Group sortingGroup = new Group(composite, 0);
        sortingGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        sortingGroup.setText(Messages.getString("SchemaViewSortingDialog.Sorting"));
        sortingGroup.setLayout((Layout)new GridLayout());
        Composite sortingGroupComposite = new Composite((Composite)sortingGroup, 0);
        GridLayout gl = new GridLayout(4, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        sortingGroupComposite.setLayout((Layout)gl);
        sortingGroupComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        Label sortByLabel = new Label(sortingGroupComposite, 0);
        sortByLabel.setText(Messages.getString("SchemaViewSortingDialog.SortBy"));
        this.sortingCombo = new Combo(sortingGroupComposite, 2060);
        this.sortingCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.sortingCombo.setItems(new String[]{Messages.getString("SchemaViewSortingDialog.FirstName"), Messages.getString("SchemaViewSortingDialog.OID")});
        this.sortingCombo.setEnabled(true);
        this.ascendingButton = new Button(sortingGroupComposite, 16);
        this.ascendingButton.setText(Messages.getString("SchemaViewSortingDialog.Ascending"));
        this.ascendingButton.setEnabled(true);
        this.descendingButton = new Button(sortingGroupComposite, 16);
        this.descendingButton.setText(Messages.getString("SchemaViewSortingDialog.Descending"));
        this.descendingButton.setEnabled(true);
        this.initFieldsFromPreferences();
        SchemaViewSortingDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initFieldsFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int grouping = store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING);
        if (grouping == 0) {
            this.inFoldersButton.setSelection(true);
        } else if (grouping == 1) {
            this.mixedButton.setSelection(true);
        }
        int sortingBy = store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY);
        if (sortingBy == 0) {
            this.sortingCombo.select(0);
        } else if (sortingBy == 1) {
            this.sortingCombo.select(1);
        }
        int sortingOrder = store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER);
        if (sortingOrder == 0) {
            this.ascendingButton.setSelection(true);
        } else if (sortingOrder == 1) {
            this.descendingButton.setSelection(true);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            if (this.inFoldersButton.getSelection() && !this.mixedButton.getSelection()) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING, 0);
            } else if (!this.inFoldersButton.getSelection() && this.mixedButton.getSelection()) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_GROUPING, 1);
            }
            if (this.sortingCombo.getItem(this.sortingCombo.getSelectionIndex()).equals(Messages.getString("SchemaViewSortingDialog.FirstName"))) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY, 0);
            } else if (this.sortingCombo.getItem(this.sortingCombo.getSelectionIndex()).equals(Messages.getString("SchemaViewSortingDialog.OID"))) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_BY, 1);
            }
            if (this.ascendingButton.getSelection() && !this.descendingButton.getSelection()) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER, 0);
            } else if (!this.ascendingButton.getSelection() && this.descendingButton.getSelection()) {
                store.setValue(PluginConstants.PREFS_SCHEMA_VIEW_SORTING_ORDER, 1);
            }
        }
        super.buttonPressed(buttonId);
    }
}

