/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.ProjectsHandler;
import org.apache.directory.studio.schemaeditor.model.ProjectType;
import org.apache.directory.studio.schemaeditor.view.wizards.AbstractWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewProjectWizardInformationPage
extends AbstractWizardPage {
    private ProjectsHandler projectsHandler;
    private Text nameText;
    private Button typeOnlineRadio;
    private Button typeOfflineRadio;

    protected NewProjectWizardInformationPage() {
        super("NewProjectWizardInformationPage");
        this.setTitle(Messages.getString("NewProjectWizardInformationPage.CreateSchemaProject"));
        this.setDescription(Messages.getString("NewProjectWizardInformationPage.SpecifiyNameAndType"));
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/project_new_wizard.png"));
        this.projectsHandler = Activator.getDefault().getProjectsHandler();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("NewProjectWizardInformationPage.ProjectName"));
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0, true, false));
        if (PluginUtils.getSchemaConnectors().size() > 0) {
            Group typeGroup = new Group(composite, 0);
            typeGroup.setText(Messages.getString("NewProjectWizardInformationPage.Type"));
            typeGroup.setLayout((Layout)new GridLayout());
            typeGroup.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.typeOfflineRadio = new Button((Composite)typeGroup, 16);
            this.typeOfflineRadio.setText(Messages.getString("NewProjectWizardInformationPage.OfflineSchema"));
            this.typeOfflineRadio.setLayoutData((Object)new GridData(4, 0, true, false));
            this.typeOnlineRadio = new Button((Composite)typeGroup, 16);
            this.typeOnlineRadio.setText(Messages.getString("NewProjectWizardInformationPage.OnlineSchema"));
            this.typeOnlineRadio.setLayoutData((Object)new GridData(4, 0, true, false));
        }
        this.initFields();
        this.addListeners();
        this.setControl((Control)composite);
    }

    private void initFields() {
        if (this.typeOfflineRadio != null) {
            this.typeOfflineRadio.setSelection(true);
        }
        this.displayErrorMessage(null);
        this.setPageComplete(false);
    }

    private void addListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectWizardInformationPage.this.dialogChanged();
            }
        });
        SelectionAdapter dialogChangedSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProjectWizardInformationPage.this.dialogChanged();
            }
        };
        this.typeOfflineRadio.addSelectionListener((SelectionListener)dialogChangedSelectionListener);
        this.typeOnlineRadio.addSelectionListener((SelectionListener)dialogChangedSelectionListener);
    }

    private void dialogChanged() {
        if (this.nameText.getText().equals("")) {
            this.displayErrorMessage(Messages.getString("NewProjectWizardInformationPage.ErrorNoNameSpecified"));
            return;
        }
        if (this.projectsHandler.isProjectNameAlreadyTaken(this.nameText.getText())) {
            this.displayErrorMessage(Messages.getString("NewProjectWizardInformationPage.ErrorProjectNameExists"));
            return;
        }
        this.displayErrorMessage(null);
    }

    public String getProjectName() {
        return this.nameText.getText();
    }

    public ProjectType getProjectType() {
        if (this.typeOnlineRadio != null) {
            if (this.typeOnlineRadio.getSelection()) {
                return ProjectType.ONLINE;
            }
            return ProjectType.OFFLINE;
        }
        return ProjectType.OFFLINE;
    }
}

