/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.lang.reflect.InvocationTargetException;
import org.apache.directory.server.config.ConfigWriter;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.Configuration;
import org.apache.directory.studio.apacheds.configuration.editor.ErrorPage;
import org.apache.directory.studio.apacheds.configuration.editor.KerberosServerPage;
import org.apache.directory.studio.apacheds.configuration.editor.LdapLdapsServersPage;
import org.apache.directory.studio.apacheds.configuration.editor.LoadingPage;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.NewServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.OverviewPage;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionsPage;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPoliciesPage;
import org.apache.directory.studio.apacheds.configuration.editor.ReplicationPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditorUtils;
import org.apache.directory.studio.apacheds.configuration.jobs.LoadConfigurationRunnable;
import org.apache.directory.studio.apacheds.configuration.jobs.SaveConfigurationRunnable;
import org.apache.directory.studio.common.core.jobs.StudioJob;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class ServerConfigurationEditor
extends FormEditor
implements IPageChangedListener {
    public static final String ID = ServerConfigurationEditor.class.getName();
    private boolean dirty = false;
    private Configuration configuration;
    private LoadingPage loadingPage;
    private OverviewPage overviewPage;
    private LdapLdapsServersPage ldapLdapsServersPage;
    private KerberosServerPage kerberosServerPage;
    private PartitionsPage partitionsPage;
    private PasswordPoliciesPage passwordPolicyPage;
    private ReplicationPage replicationPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        if (input instanceof NewServerConfigurationInput) {
            this.setDirty(true);
        }
        this.addPageChangedListener(this);
        this.readConfiguration();
    }

    private void readConfiguration() {
        StudioJob job = new StudioJob(new StudioRunnableWithProgress[]{new LoadConfigurationRunnable(this)});
        job.schedule();
    }

    public void pageChanged(PageChangedEvent event) {
        Object selectedPage = event.getSelectedPage();
        if (selectedPage instanceof ServerConfigurationEditorPage) {
            ((ServerConfigurationEditorPage)((Object)selectedPage)).refreshUI();
        }
    }

    protected void addPages() {
        try {
            this.loadingPage = new LoadingPage(this);
            this.addPage((IFormPage)this.loadingPage);
        }
        catch (PartInitException partInitException) {}
        this.showOrHideTabFolder();
    }

    private void showOrHideTabFolder() {
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            CTabFolder folder = (CTabFolder)container;
            if (this.getPageCount() == 1) {
                folder.setTabHeight(0);
            } else {
                folder.setTabHeight(-1);
            }
            folder.layout(true, true);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.doSavePages(monitor);
        StudioJob job = new StudioJob(new StudioRunnableWithProgress[]{new SaveConfigurationRunnable(this)});
        job.schedule();
    }

    public void doSaveAs() {
        try {
            this.getSite().getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.getString("ServerConfigurationEditor.SavingServerConfiguration"), -1);
                        ServerConfigurationEditor.this.doSaveAs(monitor);
                        monitor.done();
                    }
                    catch (Exception exception) {}
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean doSaveAs(IProgressMonitor monitor) throws Exception {
        boolean success;
        this.doSavePages(monitor);
        IEditorInput newInput = ServerConfigurationEditorUtils.saveAs(monitor, this.getSite().getShell(), this.getEditorInput(), this.getConfigWriter(), this.getConfiguration(), true);
        boolean bl = success = newInput != null;
        if (success) {
            this.setInput(newInput);
            this.setDirty(false);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ServerConfigurationEditor.this.setPartName(ServerConfigurationEditor.this.getEditorInput().getName());
                }
            });
        }
        return success;
    }

    private void doSavePages(final IProgressMonitor monitor) {
        if (this.partitionsPage != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ServerConfigurationEditor.this.partitionsPage.doSave(monitor);
                }
            });
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ServerConfigurationEditor.this.firePropertyChange(257);
            }
        });
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void resetConfiguration(Configuration configuration) {
        this.setConfiguration(configuration);
        this.setDirty(true);
        this.overviewPage.refreshUI();
        this.ldapLdapsServersPage.refreshUI();
        this.kerberosServerPage.refreshUI();
        this.partitionsPage.refreshUI();
        this.passwordPolicyPage.refreshUI();
        this.replicationPage.refreshUI();
    }

    public void configurationLoaded(Configuration configuration) {
        this.setConfiguration(configuration);
        this.hideLoadingPageAndDisplayConfigPages();
    }

    public void configurationLoadFailed(Exception exception) {
        this.setDirty(false);
        this.hideLoadingPageAndDisplayErrorPage(exception);
    }

    private void hideLoadingPageAndDisplayConfigPages() {
        this.removePage(0);
        try {
            this.overviewPage = new OverviewPage(this);
            this.addPage((IFormPage)this.overviewPage);
            this.ldapLdapsServersPage = new LdapLdapsServersPage(this);
            this.addPage((IFormPage)this.ldapLdapsServersPage);
            this.kerberosServerPage = new KerberosServerPage(this);
            this.addPage((IFormPage)this.kerberosServerPage);
            this.partitionsPage = new PartitionsPage(this);
            this.addPage((IFormPage)this.partitionsPage);
            this.passwordPolicyPage = new PasswordPoliciesPage(this);
            this.addPage((IFormPage)this.passwordPolicyPage);
            this.replicationPage = new ReplicationPage(this);
            this.addPage((IFormPage)this.replicationPage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.setActivePage(0);
        this.showOrHideTabFolder();
    }

    private void hideLoadingPageAndDisplayErrorPage(Exception exception) {
        this.removePage(0);
        try {
            this.addPage((IFormPage)new ErrorPage(this, exception));
        }
        catch (PartInitException partInitException) {}
        this.setActivePage(0);
        this.showOrHideTabFolder();
    }

    public void showPage(Class<?> pageClass) {
        if (pageClass != null) {
            for (Object page : this.pages) {
                if (!pageClass.isInstance(page)) continue;
                this.setActivePage(this.pages.indexOf(page));
                return;
            }
        }
    }

    public ConfigWriter getConfigWriter() throws Exception {
        return new ConfigWriter(ApacheDS2ConfigurationPlugin.getDefault().getSchemaManager(), this.configuration.getConfigBean());
    }
}

