/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser;

import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.ObjectClassDescriptionDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaBrowser;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaDetailsPage;
import org.apache.directory.studio.ldapbrowser.ui.editors.schemabrowser.SchemaPage;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class ObjectClassDescriptionPage
extends SchemaPage {
    public ObjectClassDescriptionPage(SchemaBrowser schemaBrowser) {
        super(schemaBrowser);
    }

    @Override
    protected String getTitle() {
        return Messages.getString("ObjectClassDescriptionPage.ObjectClasses");
    }

    @Override
    protected String getFilterDescription() {
        return Messages.getString("ObjectClassDescriptionPage.SelectObjectClass");
    }

    @Override
    protected IStructuredContentProvider getContentProvider() {
        return new OCDContentProvider();
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return new OCDLabelProvider();
    }

    @Override
    protected ViewerSorter getSorter() {
        return new OCDViewerSorter();
    }

    @Override
    protected ViewerFilter getFilter() {
        return new OCDViewerFilter();
    }

    @Override
    protected SchemaDetailsPage getDetailsPage() {
        return new ObjectClassDescriptionDetailsPage(this, this.toolkit);
    }

    class OCDContentProvider
    implements IStructuredContentProvider {
        OCDContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Schema schema;
            if (inputElement instanceof Schema && (schema = (Schema)inputElement) != null) {
                return schema.getObjectClassDescriptions().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class OCDLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OCDLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ObjectClass) {
                return SchemaUtils.toString((AbstractSchemaObject)((ObjectClass)obj));
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class OCDViewerFilter
    extends ViewerFilter {
        OCDViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ObjectClass) {
                ObjectClass ocd = (ObjectClass)element;
                boolean matched = Strings.toLowerCase((String)SchemaUtils.toString((AbstractSchemaObject)ocd)).indexOf(Strings.toLowerCase((String)ObjectClassDescriptionPage.this.filterText.getText())) != -1 || Strings.toLowerCase((String)ocd.getOid()).indexOf(Strings.toLowerCase((String)ObjectClassDescriptionPage.this.filterText.getText())) != -1;
                return matched;
            }
            return false;
        }
    }

    class OCDViewerSorter
    extends ViewerSorter {
        OCDViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ObjectClass) {
                e1 = SchemaUtils.toString((AbstractSchemaObject)((ObjectClass)e1));
            }
            if (e2 instanceof ObjectClass) {
                e2 = SchemaUtils.toString((AbstractSchemaObject)((ObjectClass)e2));
            }
            return e1.toString().compareTo(e2.toString());
        }
    }
}

