/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.io.File;
import org.apache.directory.server.core.api.AbstractLayout;

public class InstanceLayout
extends AbstractLayout {
    private static final String LOG_DIR = "apacheds.log.dir";
    private static final String RUN_DIR = "apacheds.run.dir";
    public static final String LOG_NAME = "log";
    public static final String RUN_NAME = "run";
    public static final String CONF_NAME = "conf";
    public static final String PARTITIONS_NAME = "partitions";
    private static final String REPL_NAME = "syncrepl-data";
    private static final String CACHE_NAME = "cache";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String WRAPPER_CONF = "wrapper.conf";
    private static final String CONFIG_LDIF = "config.ldif";
    private static final String KEYSTORE_FILE = "apacheds.ks";
    private File logDir;
    private File partitionsDir;
    private File runDir;
    private File confDir;
    private File replDir;
    private File cacheDir;

    public InstanceLayout(File instanceDirectory) {
        super(instanceDirectory);
        this.init();
    }

    public InstanceLayout(String instanceDirectoryPath) {
        super(instanceDirectoryPath);
        this.init();
    }

    private void init() {
        File[] requiredDirectories = new File[]{this.getInstanceDirectory(), this.getConfDirectory(), this.getLogDirectory(), this.getPartitionsDirectory(), this.getRunDirectory(), this.getCacheDirectory()};
        this.setRequiredDirectories(requiredDirectories);
        File[] requiredFiles = new File[]{this.getWrapperConfigurationFile(), this.getLogConfigurationFile()};
        this.setRequiredFiles(requiredFiles);
    }

    public File getConfDirectory() {
        if (this.confDir == null) {
            this.confDir = new File(this.getInstanceDirectory(), CONF_NAME);
        }
        return this.confDir;
    }

    public void setConfDir(File confDir) {
        this.confDir = confDir;
    }

    public File getCacheDirectory() {
        if (this.cacheDir == null) {
            this.cacheDir = new File(this.getInstanceDirectory(), CACHE_NAME);
        }
        return this.cacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public File getLogDirectory() {
        if (this.logDir == null) {
            String systemLogDir = System.getProperty(LOG_DIR);
            this.logDir = systemLogDir != null ? new File(systemLogDir) : new File(this.getInstanceDirectory(), LOG_NAME);
        }
        return this.logDir;
    }

    public void setLogDir(File logDir) {
        this.logDir = logDir;
    }

    public File getPartitionsDirectory() {
        if (this.partitionsDir == null) {
            this.partitionsDir = new File(this.getInstanceDirectory(), PARTITIONS_NAME);
        }
        return this.partitionsDir;
    }

    public void setPartitionsDir(File partitionsDir) {
        this.partitionsDir = partitionsDir;
    }

    public File getRunDirectory() {
        if (this.runDir == null) {
            String systemRunDir = System.getProperty(RUN_DIR);
            this.runDir = systemRunDir != null ? new File(systemRunDir) : new File(this.getInstanceDirectory(), RUN_NAME);
        }
        return this.runDir;
    }

    public void setRunDir(File runDir) {
        this.runDir = runDir;
    }

    public File getInstanceDirectory() {
        return this.getDirectory();
    }

    public File getLogConfigurationFile() {
        return new File(this.getConfDirectory(), LOG4J_PROPERTIES);
    }

    public File getWrapperConfigurationFile() {
        return new File(this.getConfDirectory(), WRAPPER_CONF);
    }

    public File getApacheDsConfigurationLdifFile() {
        return new File(this.getConfDirectory(), CONFIG_LDIF);
    }

    public File getKeyStoreFile() {
        return new File(this.getConfDirectory(), KEYSTORE_FILE);
    }

    public File getReplDirectory() {
        if (this.replDir == null) {
            this.replDir = new File(this.getInstanceDirectory(), REPL_NAME);
        }
        return this.replDir;
    }

    public void setReplDirectory(File replDir) {
        this.replDir = replDir;
    }

    public String toString() {
        return "Instance Layout: \n  Instance dir                  : " + this.getInstanceDirectory() + "\n  Instance conf dir             : " + this.getConfDirectory() + "\n  Instance log dir              : " + this.getLogDirectory() + "\n  Instance run dir              : " + this.getRunDirectory() + "\n  Instance partitions dir       : " + this.getPartitionsDirectory() + "\n  Instance replication data dir : " + this.getReplDirectory() + "\n  Instance cache dir            : " + this.getCacheDirectory() + "\n";
    }
}

