/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaIT;
import org.apache.directory.api.ldap.model.message.controls.PagedResults;
import org.apache.directory.api.ldap.model.message.controls.Subentries;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.ui.widgets.AbstractWidget;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyEvent;
import org.apache.directory.studio.common.ui.widgets.WidgetModifyListener;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.Controls;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.AliasesDereferencingWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.BrowserConnectionWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.EntryWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.FilterWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.LimitWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.ReferralsHandlingWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.ReturningAttributesWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.ScopeWidget;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SearchPageWrapper
extends AbstractWidget {
    public static final int NONE = 0;
    public static final int NAME_INVISIBLE = 2;
    public static final int NAME_READONLY = 4;
    public static final int CONNECTION_INVISIBLE = 8;
    public static final int CONNECTION_READONLY = 16;
    public static final int SEARCHBASE_INVISIBLE = 32;
    public static final int SEARCHBASE_READONLY = 64;
    public static final int FILTER_INVISIBLE = 128;
    public static final int FILTER_READONLY = 256;
    public static final int RETURNINGATTRIBUTES_INVISIBLE = 512;
    public static final int RETURNINGATTRIBUTES_READONLY = 1024;
    public static final int RETURN_DN_VISIBLE = 2048;
    public static final int RETURN_DN_CHECKED = 4096;
    public static final int RETURN_ALLATTRIBUTES_VISIBLE = 8192;
    public static final int RETURN_ALLATTRIBUTES_CHECKED = 16384;
    public static final int RETURN_OPERATIONALATTRIBUTES_VISIBLE = 32768;
    public static final int RETURN_OPERATIONALATTRIBUTES_CHECKED = 65536;
    public static final int OPTIONS_INVISIBLE = 0x200000;
    public static final int SCOPEOPTIONS_READONLY = 0x400000;
    public static final int LIMITOPTIONS_READONLY = 0x800000;
    public static final int ALIASOPTIONS_READONLY = 0x1000000;
    public static final int REFERRALOPTIONS_READONLY = 0x2000000;
    public static final int REFERRALOPTIONS_FOLLOW_MANUAL_INVISIBLE = 0x4000000;
    public static final int CONTROLS_INVISIBLE = 0x40000000;
    protected int style;
    protected Label searchNameLabel;
    protected Text searchNameText;
    protected Label connectionLabel;
    protected BrowserConnectionWidget browserConnectionWidget;
    protected Label searchBaseLabel;
    protected EntryWidget searchBaseWidget;
    protected Label filterLabel;
    protected FilterWidget filterWidget;
    protected Label returningAttributesLabel;
    protected ReturningAttributesWidget returningAttributesWidget;
    protected Button returnDnButton;
    protected Button returnAllAttributesButton;
    protected Button returnOperationalAttributesButton;
    protected ScopeWidget scopeWidget;
    protected LimitWidget limitWidget;
    protected AliasesDereferencingWidget aliasesDereferencingWidget;
    protected ReferralsHandlingWidget referralsHandlingWidget;
    protected Group controlGroup;
    protected Button manageDsaItControlButton;
    protected Button subentriesControlButton;
    protected Button pagedSearchControlButton;
    protected Label pagedSearchControlSizeLabel;
    protected Text pagedSearchControlSizeText;
    protected Button pagedSearchControlScrollButton;

    public SearchPageWrapper(int style) {
        this.style = style;
    }

    public void createContents(Composite composite) {
        this.createSearchNameLine(composite);
        this.createConnectionLine(composite);
        this.createSearchBaseLine(composite);
        this.createFilterLine(composite);
        this.createReturningAttributesLine(composite);
        this.createControlComposite(composite);
        this.createOptionsComposite(composite);
    }

    protected boolean isActive(int requiredStyle) {
        return (this.style & requiredStyle) != 0;
    }

    protected void createSearchNameLine(Composite composite) {
        if (this.isActive(2)) {
            return;
        }
        this.searchNameLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchPageWrapper.SearchName"), (int)1);
        this.searchNameText = this.isActive(4) ? BaseWidgetUtils.createReadonlyText((Composite)composite, (String)"", (int)2) : BaseWidgetUtils.createText((Composite)composite, (String)"", (int)2);
        this.searchNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
        this.searchNameText.setFocus();
        BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
    }

    protected void createConnectionLine(Composite composite) {
        if (this.isActive(8)) {
            return;
        }
        this.connectionLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchPageWrapper.Connection"), (int)1);
        this.browserConnectionWidget = new BrowserConnectionWidget();
        this.browserConnectionWidget.createWidget(composite);
        this.browserConnectionWidget.setEnabled(!this.isActive(16));
        this.browserConnectionWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
    }

    protected void createSearchBaseLine(Composite composite) {
        if (this.isActive(32)) {
            return;
        }
        this.searchBaseLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchPageWrapper.SearchBase"), (int)1);
        this.searchBaseWidget = new EntryWidget();
        this.searchBaseWidget.createWidget(composite);
        this.searchBaseWidget.setEnabled(!this.isActive(64));
        this.searchBaseWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
    }

    protected void createFilterLine(Composite composite) {
        if (this.isActive(128)) {
            return;
        }
        this.filterLabel = BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchPageWrapper.Filter"), (int)1);
        this.filterWidget = new FilterWidget();
        this.filterWidget.createWidget(composite);
        this.filterWidget.setEnabled(!this.isActive(256));
        this.filterWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
    }

    protected void createReturningAttributesLine(Composite composite) {
        if (this.isActive(512)) {
            return;
        }
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("SearchPageWrapper.ReturningAttributes"), (int)1);
        Composite retComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)2);
        this.returningAttributesWidget = new ReturningAttributesWidget();
        this.returningAttributesWidget.createWidget(retComposite);
        this.returningAttributesWidget.setEnabled(!this.isActive(1024));
        this.returningAttributesWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        if (this.isActive(2048) || this.isActive(8192) || this.isActive(32768)) {
            BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
            Composite buttonComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)3, (int)2);
            if (this.isActive(2048)) {
                this.returnDnButton = BaseWidgetUtils.createCheckbox((Composite)buttonComposite, (String)Messages.getString("SearchPageWrapper.ExportDN"), (int)1);
                this.returnDnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SearchPageWrapper.this.validate();
                    }
                });
                this.returnDnButton.setSelection(this.isActive(4096));
            }
            if (this.isActive(8192)) {
                this.returnAllAttributesButton = BaseWidgetUtils.createCheckbox((Composite)buttonComposite, (String)Messages.getString("SearchPageWrapper.AllUserAttributes"), (int)1);
                this.returnAllAttributesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SearchPageWrapper.this.validate();
                    }
                });
                this.returnAllAttributesButton.setSelection(this.isActive(16384));
            }
            if (this.isActive(32768)) {
                this.returnOperationalAttributesButton = BaseWidgetUtils.createCheckbox((Composite)buttonComposite, (String)Messages.getString("SearchPageWrapper.OperationalAttributes"), (int)1);
                this.returnOperationalAttributesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SearchPageWrapper.this.validate();
                    }
                });
                this.returnOperationalAttributesButton.setSelection(this.isActive(65536));
            }
        }
        BaseWidgetUtils.createSpacer((Composite)composite, (int)3);
    }

    protected void createOptionsComposite(Composite composite) {
        if (this.isActive(0x200000)) {
            return;
        }
        Composite optionsComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)2, (int)3);
        this.scopeWidget = new ScopeWidget();
        this.scopeWidget.createWidget(optionsComposite);
        this.scopeWidget.setEnabled(!this.isActive(0x400000));
        this.scopeWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        this.limitWidget = new LimitWidget();
        this.limitWidget.createWidget(optionsComposite);
        this.limitWidget.setEnabled(!this.isActive(0x800000));
        this.limitWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        this.aliasesDereferencingWidget = new AliasesDereferencingWidget();
        this.aliasesDereferencingWidget.createWidget(optionsComposite);
        this.aliasesDereferencingWidget.setEnabled(!this.isActive(0x1000000));
        this.aliasesDereferencingWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
        this.referralsHandlingWidget = new ReferralsHandlingWidget();
        this.referralsHandlingWidget.createWidget(optionsComposite, !this.isActive(0x4000000));
        this.referralsHandlingWidget.setEnabled(!this.isActive(0x2000000));
        this.referralsHandlingWidget.addWidgetModifyListener(new WidgetModifyListener(){

            public void widgetModified(WidgetModifyEvent event) {
                SearchPageWrapper.this.validate();
            }
        });
    }

    protected void createControlComposite(Composite composite) {
        if (this.isActive(0x40000000)) {
            return;
        }
        Composite controlComposite = BaseWidgetUtils.createColumnContainer((Composite)composite, (int)1, (int)3);
        this.controlGroup = BaseWidgetUtils.createGroup((Composite)controlComposite, (String)Messages.getString("SearchPageWrapper.Controls"), (int)1);
        this.manageDsaItControlButton = BaseWidgetUtils.createCheckbox((Composite)this.controlGroup, (String)Messages.getString("SearchPageWrapper.ManageDsaIt"), (int)1);
        this.manageDsaItControlButton.setToolTipText(Messages.getString("SearchPageWrapper.ManageDsaItTooltip"));
        this.manageDsaItControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
        this.subentriesControlButton = BaseWidgetUtils.createCheckbox((Composite)this.controlGroup, (String)Messages.getString("SearchPageWrapper.Subentries"), (int)1);
        this.subentriesControlButton.setToolTipText(Messages.getString("SearchPageWrapper.SubentriesTooltip"));
        this.subentriesControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
        Composite sprcComposite = BaseWidgetUtils.createColumnContainer((Composite)this.controlGroup, (int)4, (int)1);
        this.pagedSearchControlButton = BaseWidgetUtils.createCheckbox((Composite)sprcComposite, (String)Messages.getString("SearchPageWrapper.PagedSearch"), (int)1);
        this.pagedSearchControlButton.setToolTipText(Messages.getString("SearchPageWrapper.PagedSearchToolTip"));
        this.pagedSearchControlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
        this.pagedSearchControlSizeLabel = BaseWidgetUtils.createLabel((Composite)sprcComposite, (String)Messages.getString("SearchPageWrapper.PageSize"), (int)1);
        this.pagedSearchControlSizeText = BaseWidgetUtils.createText((Composite)sprcComposite, (String)"100", (int)5, (int)1);
        this.pagedSearchControlSizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0-9]*")) {
                    e.doit = false;
                }
            }
        });
        this.pagedSearchControlSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
        this.pagedSearchControlScrollButton = BaseWidgetUtils.createCheckbox((Composite)sprcComposite, (String)Messages.getString("SearchPageWrapper.ScrollMode"), (int)1);
        this.pagedSearchControlScrollButton.setToolTipText(Messages.getString("SearchPageWrapper.ScrollModeToolTip"));
        this.pagedSearchControlScrollButton.setSelection(true);
        this.pagedSearchControlScrollButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPageWrapper.this.validate();
            }
        });
    }

    protected void validate() {
        if (this.browserConnectionWidget.getBrowserConnection() != null && (this.searchBaseWidget.getDn() == null || this.searchBaseWidget.getBrowserConnection() != this.browserConnectionWidget.getBrowserConnection())) {
            this.searchBaseWidget.setInput(this.browserConnectionWidget.getBrowserConnection(), null);
        }
        this.filterWidget.setBrowserConnection(this.browserConnectionWidget.getBrowserConnection());
        this.pagedSearchControlSizeLabel.setEnabled(this.pagedSearchControlButton.getSelection());
        this.pagedSearchControlSizeText.setEnabled(this.pagedSearchControlButton.getSelection());
        this.pagedSearchControlScrollButton.setEnabled(this.pagedSearchControlButton.getSelection());
        super.notifyListeners();
    }

    public boolean isReturnDn() {
        return this.returnDnButton != null && this.returnDnButton.getSelection();
    }

    public void loadFromSearch(ISearch search) {
        if (this.searchNameText != null) {
            this.searchNameText.setText(search.getName());
        }
        if (search.getBrowserConnection() != null) {
            List searchControls;
            IBrowserConnection browserConnection = search.getBrowserConnection();
            Dn searchBase = search.getSearchBase();
            if (this.browserConnectionWidget != null) {
                this.browserConnectionWidget.setBrowserConnection(browserConnection);
            }
            if (searchBase != null) {
                this.searchBaseWidget.setInput(browserConnection, searchBase);
            }
            if (this.filterWidget != null) {
                this.filterWidget.setBrowserConnection(browserConnection);
                this.filterWidget.setFilter(search.getFilter());
            }
            if (this.returningAttributesWidget != null) {
                this.returningAttributesWidget.setBrowserConnection(browserConnection);
                this.returningAttributesWidget.setInitialReturningAttributes(search.getReturningAttributes());
            }
            if (this.scopeWidget != null) {
                this.scopeWidget.setScope(search.getScope());
            }
            if (this.limitWidget != null) {
                this.limitWidget.setCountLimit(search.getCountLimit());
                this.limitWidget.setTimeLimit(search.getTimeLimit());
            }
            if (this.aliasesDereferencingWidget != null) {
                this.aliasesDereferencingWidget.setAliasesDereferencingMethod(search.getAliasesDereferencingMethod());
            }
            if (this.referralsHandlingWidget != null) {
                this.referralsHandlingWidget.setReferralsHandlingMethod(search.getReferralsHandlingMethod());
            }
            if (this.subentriesControlButton != null && (searchControls = search.getControls()) != null && searchControls.size() > 0) {
                for (Control c : searchControls) {
                    if (c instanceof ManageDsaIT) {
                        this.manageDsaItControlButton.setSelection(true);
                        continue;
                    }
                    if (c instanceof Subentries) {
                        this.subentriesControlButton.setSelection(true);
                        continue;
                    }
                    if (!(c instanceof PagedResults)) continue;
                    this.pagedSearchControlButton.setSelection(true);
                    this.pagedSearchControlSizeText.setText("" + ((PagedResults)c).getSize());
                    this.pagedSearchControlScrollButton.setSelection(search.isPagedSearchScrollMode());
                }
            }
        }
    }

    public boolean saveToSearch(ISearch search) {
        Connection.ReferralHandlingMethod referralsHandlingMethod;
        Connection.AliasDereferencingMethod aliasesDereferencingMethod;
        SearchScope scope;
        boolean searchModified = false;
        if (this.searchNameText != null && !this.searchNameText.getText().equals(search.getName())) {
            search.getSearchParameter().setName(this.searchNameText.getText());
            searchModified = true;
        }
        if (this.browserConnectionWidget != null && this.browserConnectionWidget.getBrowserConnection() != null && this.browserConnectionWidget.getBrowserConnection() != search.getBrowserConnection()) {
            search.setBrowserConnection(this.browserConnectionWidget.getBrowserConnection());
            searchModified = true;
        }
        if (this.searchBaseWidget != null && this.searchBaseWidget.getDn() != null && !this.searchBaseWidget.getDn().equals((Object)search.getSearchBase())) {
            search.getSearchParameter().setSearchBase(this.searchBaseWidget.getDn());
            searchModified = true;
            this.searchBaseWidget.saveDialogSettings();
        }
        if (this.filterWidget != null && this.filterWidget.getFilter() != null) {
            if (!this.filterWidget.getFilter().equals(search.getFilter())) {
                search.getSearchParameter().setFilter(this.filterWidget.getFilter());
                searchModified = true;
            }
            this.filterWidget.saveDialogSettings();
        }
        if (this.returningAttributesWidget != null) {
            if (!Arrays.equals(this.returningAttributesWidget.getReturningAttributes(), search.getReturningAttributes())) {
                search.getSearchParameter().setReturningAttributes(this.returningAttributesWidget.getReturningAttributes());
                searchModified = true;
            }
            this.returningAttributesWidget.saveDialogSettings();
            if (this.returnAllAttributesButton != null || this.returnOperationalAttributesButton != null) {
                ArrayList<String> raList = new ArrayList<String>();
                raList.addAll(Arrays.asList(search.getReturningAttributes()));
                if (this.returnAllAttributesButton != null) {
                    if (this.returnAllAttributesButton.getSelection()) {
                        raList.add("*");
                    }
                    if (this.returnAllAttributesButton.getSelection() != this.isActive(16384)) {
                        searchModified = true;
                    }
                }
                if (this.returnOperationalAttributesButton != null) {
                    if (this.returnOperationalAttributesButton.getSelection()) {
                        Collection opAtds = SchemaUtils.getOperationalAttributeDescriptions((Schema)this.browserConnectionWidget.getBrowserConnection().getSchema());
                        Collection opAtdNames = SchemaUtils.getNames((Collection)opAtds);
                        raList.addAll(opAtdNames);
                        raList.add("+");
                    }
                    if (this.returnOperationalAttributesButton.getSelection() != this.isActive(65536)) {
                        searchModified = true;
                    }
                }
                String[] returningAttributes = raList.toArray(new String[raList.size()]);
                search.getSearchParameter().setReturningAttributes(returningAttributes);
            }
        }
        if (this.scopeWidget != null && (scope = this.scopeWidget.getScope()) != search.getScope()) {
            search.getSearchParameter().setScope(scope);
            searchModified = true;
        }
        if (this.limitWidget != null) {
            int countLimit = this.limitWidget.getCountLimit();
            int timeLimit = this.limitWidget.getTimeLimit();
            if (countLimit != search.getCountLimit()) {
                search.getSearchParameter().setCountLimit(countLimit);
                searchModified = true;
            }
            if (timeLimit != search.getTimeLimit()) {
                search.getSearchParameter().setTimeLimit(timeLimit);
                searchModified = true;
            }
        }
        if (this.aliasesDereferencingWidget != null && (aliasesDereferencingMethod = this.aliasesDereferencingWidget.getAliasesDereferencingMethod()) != search.getAliasesDereferencingMethod()) {
            search.getSearchParameter().setAliasesDereferencingMethod(aliasesDereferencingMethod);
            searchModified = true;
        }
        if (this.referralsHandlingWidget != null && (referralsHandlingMethod = this.referralsHandlingWidget.getReferralsHandlingMethod()) != search.getReferralsHandlingMethod()) {
            search.getSearchParameter().setReferralsHandlingMethod(referralsHandlingMethod);
            searchModified = true;
        }
        if (this.subentriesControlButton != null) {
            HashSet oldControls = new HashSet();
            oldControls.addAll(search.getSearchParameter().getControls());
            search.getSearchParameter().getControls().clear();
            if (this.manageDsaItControlButton.getSelection()) {
                search.getSearchParameter().getControls().add(Controls.MANAGEDSAIT_CONTROL);
            }
            if (this.subentriesControlButton.getSelection()) {
                search.getSearchParameter().getControls().add(Controls.SUBENTRIES_CONTROL);
            }
            if (this.pagedSearchControlButton.getSelection()) {
                int pageSize;
                try {
                    pageSize = Integer.valueOf(this.pagedSearchControlSizeText.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    pageSize = 100;
                }
                boolean isScrollMode = this.pagedSearchControlScrollButton.getSelection();
                PagedResults control = Controls.newPagedResultsControl((int)pageSize);
                search.getSearchParameter().getControls().add(control);
                search.getSearchParameter().setPagedSearchScrollMode(isScrollMode);
            }
            HashSet newControls = new HashSet();
            newControls.addAll(search.getSearchParameter().getControls());
            if (!oldControls.equals(newControls)) {
                searchModified = true;
            }
        }
        return searchModified;
    }

    public boolean performSearch(ISearch search) {
        if (search.getBrowserConnection() != null) {
            search.setSearchResults(null);
            new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(new ISearch[]{search})}).execute();
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.browserConnectionWidget != null && this.browserConnectionWidget.getBrowserConnection() == null) {
            return false;
        }
        if (this.searchBaseWidget != null && this.searchBaseWidget.getDn() == null) {
            return false;
        }
        if (this.searchNameText != null && "".equals(this.searchNameText.getText())) {
            return false;
        }
        if (this.filterWidget != null && this.filterWidget.getFilter() == null) {
            return false;
        }
        return this.pagedSearchControlButton == null || !this.pagedSearchControlButton.isEnabled() || !"".equals(this.pagedSearchControlButton.getText());
    }

    public String getErrorMessage() {
        if (this.browserConnectionWidget != null && this.browserConnectionWidget.getBrowserConnection() == null) {
            return Messages.getString("SearchPageWrapper.SelectConnection");
        }
        if (this.searchBaseWidget != null && this.searchBaseWidget.getDn() == null) {
            return Messages.getString("SearchPageWrapper.EnterValidSearchBase");
        }
        if (this.searchNameText != null && "".equals(this.searchNameText.getText())) {
            return Messages.getString("SearchPageWrapper.EnterSearchName");
        }
        if (this.filterWidget != null && this.filterWidget.getFilter() == null) {
            return Messages.getString("SearchPageWrapper.EnterValidFilter");
        }
        return null;
    }

    public void setEnabled(boolean b) {
        if (this.searchNameText != null) {
            this.searchNameLabel.setEnabled(b);
            this.searchNameText.setEnabled(b);
        }
        if (this.browserConnectionWidget != null) {
            this.connectionLabel.setEnabled(b);
            this.browserConnectionWidget.setEnabled(b && !this.isActive(16));
        }
        if (this.searchBaseWidget != null) {
            this.searchBaseLabel.setEnabled(b);
            this.searchBaseWidget.setEnabled(b && !this.isActive(64));
        }
        if (this.filterWidget != null) {
            this.filterLabel.setEnabled(b);
            this.filterWidget.setEnabled(b && !this.isActive(256));
        }
        if (this.returningAttributesWidget != null) {
            this.returningAttributesLabel.setEnabled(b);
            this.returningAttributesWidget.setEnabled(b && !this.isActive(1024));
        }
        if (this.returnDnButton != null) {
            this.returnDnButton.setEnabled(b);
        }
        if (this.returnAllAttributesButton != null) {
            this.returnAllAttributesButton.setEnabled(b);
        }
        if (this.returnOperationalAttributesButton != null) {
            this.returnOperationalAttributesButton.setEnabled(b);
        }
        if (this.scopeWidget != null) {
            this.scopeWidget.setEnabled(b && !this.isActive(0x400000));
        }
        if (this.limitWidget != null) {
            this.limitWidget.setEnabled(b && !this.isActive(0x800000));
        }
        if (this.aliasesDereferencingWidget != null) {
            this.aliasesDereferencingWidget.setEnabled(b && !this.isActive(0x1000000));
        }
        if (this.referralsHandlingWidget != null) {
            this.referralsHandlingWidget.setEnabled(b && !this.isActive(0x2000000));
        }
        if (this.controlGroup != null) {
            this.controlGroup.setEnabled(b);
            this.manageDsaItControlButton.setEnabled(b);
            this.subentriesControlButton.setEnabled(b);
        }
    }
}

