CREATE TABLE IF NOT EXISTS hits
(
    CounterID BIGINT,
    EventDate DATE,
    UserID LARGEINT,
    WatchID LARGEINT,
    JavaEnable SMALLINT,
    Title STRING,
    GoodEvent SMALLINT,
    EventTime DATETIME,
    ClientIP BIGINT,
    ClientIP6 CHAR(50),
    RegionID BIGINT,
    CounterClass TINYINT,
    OS SMALLINT,
    UserAgent SMALLINT,
    URL STRING,
    Referer STRING,
    URLDomain STRING,
    RefererDomain STRING,
    Refresh SMALLINT,
    IsRobot SMALLINT,
    RefererCategories STRING,
    URLCategories STRING,
    URLRegions STRING,
    RefererRegions STRING,
    ResolutionWidth INT,
    ResolutionHeight INT,
    ResolutionDepth SMALLINT,
    FlashMajor SMALLINT,
    FlashMinor SMALLINT,
    FlashMinor2 STRING,
    NetMajor SMALLINT,
    NetMinor SMALLINT,
    UserAgentMajor INT,
    UserAgentMinor CHAR(4),
    CookieEnable SMALLINT,
    JavascriptEnable SMALLINT,
    IsMobile SMALLINT,
    MobilePhone SMALLINT,
    MobilePhoneModel STRING,
    Params STRING,
    IPNetworkID BIGINT,
    TraficSourceID TINYINT,
    SearchEngineID INT,
    SearchPhrase STRING,
    AdvEngineID SMALLINT,
    IsArtifical SMALLINT,
    WindowClientWidth INT,
    WindowClientHeight INT,
    ClientTimeZone SMALLINT,
    ClientEventTime DATETIME,
    SilverlightVersion1 SMALLINT,
    SilverlightVersion2 SMALLINT,
    SilverlightVersion3 BIGINT,
    SilverlightVersion4 INT,
    PageCharset STRING,
    CodeVersion BIGINT,
    IsLink SMALLINT,
    IsDownload SMALLINT,
    IsNotBounce SMALLINT,
    FUniqID LARGEINT,
    HID BIGINT,
    IsOldCounter SMALLINT,
    IsEvent SMALLINT,
    IsParameter SMALLINT,
    DontCountHits SMALLINT,
    WithHash SMALLINT,
    HitColor CHAR(2),
    UTCEventTime DATETIME,
    Age SMALLINT,
    Sex SMALLINT,
    Income SMALLINT,
    Interests INT,
    Robotness SMALLINT,
    GeneralInterests STRING,
    RemoteIP BIGINT,
    RemoteIP6 CHAR(50),
    WindowName INT,
    OpenerName INT,
    HistoryLength SMALLINT,
    BrowserLanguage CHAR(4),
    BrowserCountry CHAR(4),
    SocialNetwork STRING,
    SocialAction STRING,
    HTTPError INT,
    SendTiming INT,
    DNSTiming INT,
    ConnectTiming INT,
    ResponseStartTiming INT,
    ResponseEndTiming INT,
    FetchTiming INT,
    RedirectTiming INT,
    DOMInteractiveTiming INT,
    DOMContentLoadedTiming INT,
    DOMCompleteTiming INT,
    LoadEventStartTiming INT,
    LoadEventEndTiming INT,
    NSToDOMContentLoadedTiming INT,
    FirstPaintTiming INT,
    RedirectCount TINYINT,
    SocialSourceNetworkID SMALLINT,
    SocialSourcePage STRING,
    ParamPrice BIGINT,
    ParamOrderID STRING,
    ParamCurrency CHAR(6),
    ParamCurrencyID INT,
    GoalsReached STRING,
    OpenstatServiceName STRING,
    OpenstatCampaignID STRING,
    OpenstatAdID STRING,
    OpenstatSourceID STRING,
    UTMSource STRING,
    UTMMedium STRING,
    UTMCampaign STRING,
    UTMContent STRING,
    UTMTerm STRING,
    FromTag STRING,
    HasGCLID SMALLINT,
    RefererHash LARGEINT,
    URLHash LARGEINT,
    CLID BIGINT,
    YCLID LARGEINT,
    ShareService STRING,
    ShareURL STRING,
    ShareTitle STRING,
    ParsedParamsKey1 STRING,
    ParsedParamsKey2 STRING,
    ParsedParamsKey3 STRING,
    ParsedParamsKey4 STRING,
    ParsedParamsKey5 STRING,
    ParsedParamsValueDouble DOUBLE,
    IslandID CHAR(40),
    RequestNum BIGINT,
    RequestTry SMALLINT
)
DUPLICATE KEY(CounterID, EventDate, UserID)
DISTRIBUTED BY HASH(CounterID) BUCKETS 16
PROPERTIES
(
  "replication_num" = "1"
)
