/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.servlet;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializerConfiguration;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={ResultTxtVerboseSerializer.class})
public class ResultTxtVerboseSerializer {
    private static final String NEWLINE = "\n";
    private int totalWidth;
    private int colWidthName;
    private int colWidthResult;
    private int colWidthTiming;
    private int colWidthWithoutLog;
    private int colWidthLog;

    @Activate
    protected final void activate(ResultTxtVerboseSerializerConfiguration configuration) {
        this.totalWidth = configuration.totalWidth();
        this.colWidthName = configuration.colWidthName();
        this.colWidthResult = configuration.colWidthResult();
        this.colWidthTiming = configuration.colWidthTiming();
        this.colWidthWithoutLog = this.colWidthName + this.colWidthResult + this.colWidthTiming;
        this.colWidthLog = this.totalWidth - this.colWidthWithoutLog;
    }

    public String serialize(String label, List<HealthCheckExecutionResult> executionResults, boolean includeDebug) {
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(label + NEWLINE);
        resultStr.append(this.serializeResults(executionResults, includeDebug));
        return resultStr.toString();
    }

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, boolean includeDebug) {
        StringBuilder resultStr = new StringBuilder();
        resultStr.append(StringUtils.repeat("-", this.totalWidth) + NEWLINE);
        resultStr.append(ResultTxtVerboseSerializer.center("Overall Health Result: " + overallResult.getStatus().toString(), this.totalWidth) + NEWLINE);
        resultStr.append(StringUtils.repeat("-", this.totalWidth) + NEWLINE);
        resultStr.append(ResultTxtVerboseSerializer.rightPad("Name", this.colWidthName));
        resultStr.append(ResultTxtVerboseSerializer.rightPad("Result", this.colWidthResult));
        resultStr.append(ResultTxtVerboseSerializer.rightPad("Timing", this.colWidthTiming));
        resultStr.append("Logs\n");
        resultStr.append(StringUtils.repeat("-", this.totalWidth) + NEWLINE);
        resultStr.append(this.serializeResults(executionResults, includeDebug));
        resultStr.append(StringUtils.repeat("-", this.totalWidth) + NEWLINE);
        return resultStr.toString();
    }

    private String serializeResults(List<HealthCheckExecutionResult> executionResults, boolean includeDebug) {
        StringBuilder resultStr = new StringBuilder();
        SimpleDateFormat dfShort = new SimpleDateFormat("HH:mm:ss.SSS");
        for (HealthCheckExecutionResult healthCheckResult : executionResults) {
            this.appendVerboseTxtForResult(resultStr, healthCheckResult, includeDebug, dfShort);
        }
        return resultStr.toString();
    }

    private void appendVerboseTxtForResult(StringBuilder resultStr, HealthCheckExecutionResult healthCheckResult, boolean includeDebug, DateFormat dfShort) {
        String wrappedName = this.wordWrap(healthCheckResult.getHealthCheckMetadata().getTitle(), this.colWidthName, NEWLINE);
        int lastIndexOfNewline = wrappedName.lastIndexOf(NEWLINE);
        String relevantNameStringForPadding = lastIndexOfNewline >= 0 ? wrappedName.substring(lastIndexOfNewline + 1) : wrappedName;
        int paddingSize = this.colWidthName - relevantNameStringForPadding.length();
        resultStr.append(wrappedName + StringUtils.repeat(" ", paddingSize));
        resultStr.append(ResultTxtVerboseSerializer.rightPad(healthCheckResult.getHealthCheckResult().getStatus().toString(), this.colWidthResult));
        resultStr.append(ResultTxtVerboseSerializer.rightPad("[" + dfShort.format(healthCheckResult.getFinishedAt()) + "|" + FormattingResultLog.msHumanReadable((long)healthCheckResult.getElapsedTimeInMs()) + "]", this.colWidthTiming));
        boolean isFirst = true;
        for (ResultLog.Entry logEntry : healthCheckResult.getHealthCheckResult()) {
            if (!includeDebug && logEntry.isDebug()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                resultStr.append(StringUtils.repeat(" ", this.colWidthWithoutLog));
            }
            String oneLineMessage = this.getStatusForTxtLog(logEntry) + logEntry.getMessage();
            String messageToPrint = this.wordWrap(oneLineMessage, this.colWidthLog, NEWLINE + StringUtils.repeat(" ", this.colWidthWithoutLog));
            resultStr.append(messageToPrint);
            resultStr.append(NEWLINE);
        }
        if (isFirst) {
            resultStr.append(NEWLINE);
        }
    }

    private String getStatusForTxtLog(ResultLog.Entry logEntry) {
        if (logEntry.getStatus() == Result.Status.OK) {
            return "";
        }
        return logEntry.getStatus().toString() + " ";
    }

    String wordWrap(String s, int maxWidth, String newlineDelimiter) {
        return s.replaceAll("(.{1," + maxWidth + "})(?: +|$)\\n?|(.{" + maxWidth + "})", "$1$2" + newlineDelimiter).trim();
    }

    public static String rightPad(String s, int size) {
        if (s.length() < size) {
            return s + StringUtils.repeat(" ", size - s.length());
        }
        return s;
    }

    static String center(String s, int size) {
        if (s.length() < size) {
            int padding = size - s.length();
            int paddingLeft = padding / 2;
            int paddingRight = padding / 2;
            if (padding % 2 == 1) {
                ++paddingRight;
            }
            return StringUtils.repeat(" ", paddingLeft) + s + StringUtils.repeat(" ", paddingRight);
        }
        return s;
    }
}

