/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.StatefulResolver;
import org.apache.felix.framework.resolver.CandidateComparator;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.ResolveContext;
import org.apache.felix.framework.resolver.ResolveException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveContextImpl
extends ResolveContext {
    private final StatefulResolver m_state;
    private final Map<BundleRevision, BundleWiring> m_wirings;
    private final StatefulResolver.ResolverHookRecord m_resolverHookrecord;
    private final Collection<BundleRevision> m_mandatory;
    private final Collection<BundleRevision> m_optional;
    private final Collection<BundleRevision> m_ondemand;

    ResolveContextImpl(StatefulResolver state, Map<BundleRevision, BundleWiring> wirings, StatefulResolver.ResolverHookRecord resolverHookRecord, Collection<BundleRevision> mandatory, Collection<BundleRevision> optional, Collection<BundleRevision> ondemand) {
        this.m_state = state;
        this.m_wirings = wirings;
        this.m_resolverHookrecord = resolverHookRecord;
        this.m_mandatory = mandatory;
        this.m_optional = optional;
        this.m_ondemand = ondemand;
    }

    @Override
    public Collection<BundleRevision> getMandatoryRevisions() {
        return new ArrayList<BundleRevision>(this.m_mandatory);
    }

    @Override
    public Collection<BundleRevision> getOptionalRevisions() {
        return new ArrayList<BundleRevision>(this.m_optional);
    }

    public Collection<BundleRevision> getOndemandRevisions() {
        return new ArrayList<BundleRevision>(this.m_ondemand);
    }

    @Override
    public List<BundleCapability> findProviders(BundleRequirement br, boolean obeyMandatory) {
        return this.m_state.findProvidersInternal(this.m_resolverHookrecord, br, obeyMandatory);
    }

    @Override
    public int insertHostedCapability(List<BundleCapability> caps, HostedCapability hc) {
        int idx = Collections.binarySearch(caps, hc, new CandidateComparator());
        if (idx < 0) {
            idx = Math.abs(idx + 1);
        }
        caps.add(idx, hc);
        return idx;
    }

    @Override
    public boolean isEffective(BundleRequirement br) {
        return this.m_state.isEffective(br);
    }

    @Override
    public Map<BundleRevision, BundleWiring> getWirings() {
        return this.m_wirings;
    }

    public void checkExecutionEnvironment(BundleRevision rev) throws ResolveException {
        this.m_state.checkExecutionEnvironment(rev);
    }

    public void checkNativeLibraries(BundleRevision rev) throws ResolveException {
        this.m_state.checkNativeLibraries(rev);
    }
}

