/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.support;

import aQute.bnd.maven.support.CachedPom;
import aQute.bnd.maven.support.Maven;
import aQute.bnd.maven.support.Pom;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.io.IO;
import aQute.lib.osgi.Jar;
import aQute.libg.reporter.Reporter;
import aQute.libg.version.Version;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenRemoteRepository
implements RepositoryPlugin,
RegistryPlugin,
Plugin {
    Reporter reporter;
    URI[] repositories;
    Registry registry;
    Maven maven;

    @Override
    public File[] get(String bsn, String range) throws Exception {
        File f = this.get(bsn, range, RepositoryPlugin.Strategy.HIGHEST, null);
        if (f == null) {
            return null;
        }
        return new File[]{f};
    }

    @Override
    public File get(String bsn, String version, RepositoryPlugin.Strategy strategy, Map<String, String> properties) throws Exception {
        String value;
        String groupId = null;
        if (properties != null) {
            groupId = properties.get("groupId");
        }
        if (groupId == null) {
            int n = bsn.indexOf(43);
            if (n < 0) {
                return null;
            }
            groupId = bsn.substring(0, n);
            bsn = bsn.substring(n + 1);
        }
        String artifactId = bsn;
        if (version == null) {
            if (this.reporter != null) {
                this.reporter.error("Maven dependency version not set for %s - %s", groupId, artifactId);
            }
            return null;
        }
        CachedPom pom = this.getMaven().getPom(groupId, artifactId, version, this.repositories);
        String string = value = properties == null ? null : properties.get("scope");
        if (value == null) {
            return pom.getArtifact();
        }
        Pom.Scope action = null;
        try {
            action = Pom.Scope.valueOf(value);
            return pom.getLibrary(action, this.repositories);
        }
        catch (Exception e) {
            return pom.getArtifact();
        }
    }

    public Maven getMaven() {
        if (this.maven != null) {
            return this.maven;
        }
        this.maven = this.registry.getPlugin(Maven.class);
        return this.maven;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public File put(Jar jar) throws Exception {
        throw new UnsupportedOperationException("cannot do put");
    }

    @Override
    public List<String> list(String regex) throws Exception {
        throw new UnsupportedOperationException("cannot do list");
    }

    @Override
    public List<Version> versions(String bsn) throws Exception {
        throw new UnsupportedOperationException("cannot do versions");
    }

    @Override
    public String getName() {
        return "maven";
    }

    public void setRepositories(URI ... urls) {
        this.repositories = urls;
    }

    @Override
    public void setProperties(Map<String, String> map) {
        String repoString = map.get("repositories");
        if (repoString != null) {
            String[] repos = repoString.split("\\s*,\\s*");
            this.repositories = new URI[repos.length];
            int n = 0;
            String[] stringArray = repos;
            int n2 = repos.length;
            int n3 = 0;
            while (n3 < n2) {
                block5: {
                    String repo = stringArray[n3];
                    try {
                        URI uri = new URI(repo);
                        if (!uri.isAbsolute()) {
                            uri = IO.getFile(new File(""), repo).toURI();
                        }
                        this.repositories[n++] = uri;
                    }
                    catch (Exception e) {
                        if (this.reporter == null) break block5;
                        this.reporter.error("Invalid repository %s for maven plugin, %s", repo, e);
                    }
                }
                ++n3;
            }
        }
    }

    @Override
    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setMaven(Maven maven) {
        this.maven = maven;
    }
}

