/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.lib.deployer.obr.Property;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Capability {
    private final String name;
    private final List<Property> properties;

    private Capability(String name, List<Property> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Property findProperty(String propertyName) {
        assert (propertyName != null);
        for (Property prop : this.properties) {
            if (!propertyName.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Capability [name=").append(this.name).append(", properties=").append(this.properties).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capability other = (Capability)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    /* synthetic */ Capability(String string, List list, Capability capability) {
        this(string, list);
    }

    public static class Builder {
        private String name;
        private final List<Property> properties = new LinkedList<Property>();

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }

        public Capability build() {
            if (this.name == null) {
                throw new IllegalStateException("'name' field is not initialised.");
            }
            return new Capability(this.name, Collections.unmodifiableList(this.properties), null);
        }
    }
}

