/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.declaration.service;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.ipojo.extender.ConfigurationBuilder;
import org.apache.felix.ipojo.extender.DeclarationHandle;
import org.apache.felix.ipojo.extender.InstanceBuilder;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultInstanceDeclaration;
import org.apache.felix.ipojo.extender.internal.declaration.service.DefaultConfigurationBuilder;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInstanceBuilder
implements InstanceBuilder {
    private BundleContext context;
    private String name;
    private String type;
    private String version;

    public DefaultInstanceBuilder(BundleContext context, String type) {
        this.context(context);
        this.type(type);
    }

    @Override
    public InstanceBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public InstanceBuilder type(String type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("'type' parameter cannot be null (instance must be of a given type)", new Object[0]));
        }
        this.type = type;
        return this;
    }

    @Override
    public InstanceBuilder type(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("'type' parameter cannot be null (instance must be of a given type)", new Object[0]));
        }
        return this.type(type.getName());
    }

    @Override
    public InstanceBuilder version(String version) {
        this.version = version;
        return this;
    }

    @Override
    public InstanceBuilder context(BundleContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("'context' parameter cannot be null", new Object[0]));
        }
        this.context = context;
        return this;
    }

    @Override
    public ConfigurationBuilder configure() {
        return new DefaultConfigurationBuilder(this);
    }

    public DeclarationHandle build(Dictionary<String, Object> configuration) {
        if (configuration == null) {
            configuration = new Hashtable<String, Object>();
        }
        if (this.name != null) {
            configuration.put("instance.name", this.name);
        }
        if (this.version != null) {
            configuration.put("factory.version", this.version);
        }
        return new DefaultInstanceDeclaration(this.context, this.type, configuration);
    }

    @Override
    public DeclarationHandle build() {
        return this.build(new Hashtable<String, Object>());
    }
}

