/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handler.wbp;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.handler.wbp.WhiteBoardManager;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.InvalidSyntaxException;

public class WhiteBoardPatternHandler
extends PrimitiveHandler {
    public static final String NAMESPACE = "org.apache.felix.ipojo.whiteboard";
    private List m_managers = new ArrayList(1);

    public void configure(Element elem, Dictionary dict) throws ConfigurationException {
        Element[] elems = elem.getElements("wbp", NAMESPACE);
        if (elems == null || elems.length == 0) {
            Element[] whiteboards = elem.getElements("whiteboards", NAMESPACE);
            if (whiteboards == null) {
                throw new ConfigurationException("Cannot configure the whiteboard pattern handler - no suitable configuration found");
            }
            elems = whiteboards[0].getElements("wbp", NAMESPACE);
        }
        if (elems == null) {
            throw new ConfigurationException("Cannot configure the whiteboard pattern handler - no suitable configuration found");
        }
        for (int i = 0; i < elems.length; ++i) {
            String filter = elems[i].getAttribute("filter");
            String onArrival = elems[i].getAttribute("onArrival");
            String onDeparture = elems[i].getAttribute("onDeparture");
            String onModification = elems[i].getAttribute("onModification");
            if (filter == null) {
                throw new ConfigurationException("The white board pattern element requires a filter attribute");
            }
            if (onArrival == null || onDeparture == null) {
                throw new ConfigurationException("The white board pattern element requires the onArrival and onDeparture attributes");
            }
            try {
                WhiteBoardManager wbm = new WhiteBoardManager(this, this.getInstanceManager().getContext().createFilter(filter), onArrival, onDeparture, onModification);
                this.m_managers.add(wbm);
                continue;
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("The filter " + filter + " is invalid : " + (Object)((Object)e));
            }
        }
    }

    public void start() {
    }

    public void stateChanged(int state) {
        if (state == 2) {
            for (int i = 0; i < this.m_managers.size(); ++i) {
                ((WhiteBoardManager)this.m_managers.get(i)).start();
            }
        }
    }

    public void stop() {
        for (int i = 0; i < this.m_managers.size(); ++i) {
            ((WhiteBoardManager)this.m_managers.get(i)).stop();
        }
    }
}

