/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.importer.core.upnp;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.upnp.basedriver.importer.core.upnp.UPnPServiceImpl;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.UPnPStatus;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPException;
import org.osgi.service.upnp.UPnPStateVariable;

public class UPnPActionImpl
implements UPnPAction {
    private Action act;
    private UPnPServiceImpl actsFather;

    public UPnPActionImpl(Action act, UPnPServiceImpl ser) {
        this.act = act;
        this.actsFather = ser;
    }

    public String getName() {
        return this.act.getName();
    }

    public String getReturnArgumentName() {
        return null;
    }

    public String[] getInputArgumentNames() {
        ArgumentList argsList = this.act.getInputArgumentList();
        if (argsList.size() == 0) {
            return null;
        }
        String[] inputArgs = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            inputArgs[i] = argsList.getArgument(i).getName();
        }
        return inputArgs;
    }

    public String[] getOutputArgumentNames() {
        ArgumentList argsList = this.act.getOutputArgumentList();
        if (argsList.size() == 0) {
            return null;
        }
        String[] outArgs = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            outArgs[i] = argsList.getArgument(i).getName();
        }
        return outArgs;
    }

    public UPnPStateVariable getStateVariable(String argumentName) {
        Argument arg = this.act.getArgument(argumentName);
        if (arg == null) {
            return null;
        }
        String varName = arg.getRelatedStateVariableName();
        return this.actsFather.getStateVariable(varName);
    }

    public Dictionary invoke(Dictionary args) throws Exception {
        ArgumentList argsList = new ArgumentList();
        argsList = this.act.getInputArgumentList();
        for (int i = 0; i < argsList.size(); ++i) {
            Argument argument = argsList.getArgument(i);
            String argumentName = argument.getName();
            UPnPStateVariable stateVar = this.getStateVariable(argumentName);
            String upnpType = stateVar.getUPnPDataType();
            argument.setValue(Converter.toString(args.get(argumentName), upnpType));
        }
        this.act.setInArgumentValues(argsList);
        if (this.act.postControlAction()) {
            Properties outDic = new Properties();
            ArgumentList outArgs = this.act.getOutputArgumentList();
            if (outArgs.size() == 0) {
                return null;
            }
            for (int i = 0; i < outArgs.size(); ++i) {
                Argument argument = outArgs.getArgument(i);
                String argumentName = outArgs.getArgument(i).getName();
                UPnPStateVariable stateVar = this.getStateVariable(argumentName);
                String upnpType = stateVar.getUPnPDataType();
                outDic.put(argumentName, Converter.parseString(argument.getValue(), upnpType));
            }
            return outDic;
        }
        UPnPStatus controlStatus = this.act.getControlStatus();
        throw new UPnPException(controlStatus.getCode(), controlStatus.getDescription());
    }
}

