/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import org.cybergarage.http.HTTPRequest;
import org.cybergarage.upnp.UPnP;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPPacket;
import org.cybergarage.util.Debug;

public class HTTPMUSocket {
    private InetAddress ssdpMultiGroup = null;
    private MulticastSocket ssdpMultiSock = null;
    private int port = 0;

    public HTTPMUSocket() {
    }

    public HTTPMUSocket(String addr, int port, String bindAddr) {
        this.open(addr, port, bindAddr);
    }

    protected void finalize() {
        this.close();
    }

    public String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public int getMulticastPort() {
        return this.port;
    }

    public int getLocalPort() {
        return this.ssdpMultiSock.getLocalPort();
    }

    public MulticastSocket getSocket() {
        return this.ssdpMultiSock;
    }

    public InetAddress getMulticastInetAddress() {
        return this.ssdpMultiGroup;
    }

    public String getMulticastAddress() {
        return this.getMulticastInetAddress().getHostAddress();
    }

    public boolean open(String addr, int port, InetAddress bindAddr) {
        this.port = port;
        try {
            this.ssdpMultiGroup = InetAddress.getByName(addr);
            this.ssdpMultiSock = new MulticastSocket(port);
            this.ssdpMultiSock.joinGroup(this.ssdpMultiGroup);
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean open(String addr, int port, String bindAddr) {
        try {
            return this.open(addr, port, InetAddress.getByName(bindAddr));
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
    }

    public boolean close() {
        if (this.ssdpMultiSock == null) {
            return true;
        }
        try {
            this.ssdpMultiSock.leaveGroup(this.ssdpMultiGroup);
            this.ssdpMultiSock.close();
            this.ssdpMultiSock = null;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean send(String msg, String bindAddr, int bindPort) {
        try {
            MulticastSocket msock;
            if (bindAddr != null && 0 < bindPort) {
                msock = new MulticastSocket(bindPort);
                msock.setInterface(InetAddress.getByName(bindAddr));
            } else {
                msock = new MulticastSocket();
            }
            DatagramPacket dgmPacket = new DatagramPacket(msg.getBytes(), msg.length(), this.ssdpMultiGroup, this.port);
            msock.setTimeToLive(UPnP.getTimeToLive());
            msock.send(dgmPacket);
            msock.close();
        }
        catch (Exception e) {
            Debug.warning(e);
            return false;
        }
        return true;
    }

    public boolean send(String msg) {
        return this.send(msg, null, -1);
    }

    public boolean post(HTTPRequest req, String bindAddr, int bindPort) {
        return this.send(req.toString(), bindAddr, bindPort);
    }

    public boolean post(HTTPRequest req) {
        return this.send(req.toString(), null, -1);
    }

    public SSDPPacket receive() {
        byte[] ssdvRecvBuf = new byte[SSDP.RECV_MESSAGE_BUFSIZE];
        SSDPPacket recvPacket = new SSDPPacket(ssdvRecvBuf, ssdvRecvBuf.length);
        recvPacket.setLocalAddress(this.getLocalAddress());
        try {
            this.ssdpMultiSock.receive(recvPacket.getDatagramPacket());
            recvPacket.setTimeStamp(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return recvPacket;
    }
}

