/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ReferenceValue;

public abstract class SelectorNode
extends Node {
    public ObjectValue base;
    private int flags;
    public ReferenceValue ref;
    public Node expr;
    public boolean is_package;
    private static final int RVALUE_Flag = 1;
    private static final int ATTR_Flag = 2;
    private static final int SUPER_Flag = 4;
    private static final int VOID_RESULT_Flag = 8;
    private static final int THIS_Flag = 16;
    private static final int MODE_Shift = 16;
    private static final int MODE_Mask = -65536;
    private boolean skip = false;

    public SelectorNode() {
        this.setMode(-18);
    }

    public void setBase(ObjectValue base) {
        this.base = base;
    }

    public boolean isQualified() {
        return false;
    }

    public boolean isAttributeIdentifier() {
        return false;
    }

    public boolean isAny() {
        return false;
    }

    public void setRValue(boolean is_rvalue) {
        this.flags = is_rvalue ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    public boolean isRValue() {
        return (this.flags & 1) != 0;
    }

    public void setAttr(boolean is_attr) {
        this.flags = is_attr ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    public boolean isAttr() {
        return (this.flags & 2) != 0;
    }

    public void setMode(int mode) {
        this.flags &= 0xFFFF;
        this.flags |= mode << 16;
    }

    public int getMode() {
        return this.flags >> 16;
    }

    public void setSuper(boolean is_super) {
        this.flags = is_super ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public boolean isSuper() {
        return (this.flags & 4) != 0;
    }

    public void setThis(boolean is_this) {
        this.flags = is_this ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isThis() {
        return (this.flags & 0x10) != 0;
    }

    public void voidResult() {
        this.flags |= 8;
    }

    public boolean isVoidResult() {
        return (this.flags & 8) != 0;
    }

    public IdentifierNode getIdentifier() {
        return this.expr instanceof IdentifierNode ? (IdentifierNode)this.expr : null;
    }

    public void skipNode(boolean b) {
        this.skip = b;
    }

    public boolean skip() {
        return this.skip;
    }
}

