/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.semantics.Builder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Context;

public class TypeInfo {
    private boolean is_nullable;
    private boolean is_default;
    private boolean annotate_names = false;
    private TypeValue type;
    private ObjectValue prototype;
    private QName name;

    public TypeInfo(TypeValue type) {
        this.type = type;
        this.is_nullable = true;
    }

    public TypeInfo(TypeValue type, boolean nullable, boolean is_default) {
        this.type = type;
        this.is_nullable = nullable;
        this.is_default = is_default;
        if (type != null) {
            this.prototype = type.prototype;
        }
    }

    public void clearInstance() {
        this.prototype = null;
        this.name = null;
    }

    public boolean isNullable() {
        return this.is_nullable;
    }

    public TypeValue getTypeValue() {
        return this.type;
    }

    public void setIsNullable(boolean nullable) {
        this.is_nullable = nullable;
    }

    public boolean isNumeric(Context cx) {
        return this.type == cx.intType() || this.type == cx.uintType() || this.type == cx.doubleType() || this.type == cx.numberType() || cx.statics.es4_numerics && this.type == cx.decimalType();
    }

    public int getTypeId() {
        return this.type.getTypeId();
    }

    public boolean includes(Context cx, TypeInfo other_type) {
        boolean result = false;
        result = cx.statics.es4_nullability && !this.is_nullable && other_type.is_nullable ? false : this.type.includes(cx, other_type.type);
        return result;
    }

    public QName getName() {
        if (this.name == null) {
            this.name = this.type.name;
        }
        return this.name;
    }

    public QName getName(Context cx) {
        if (this.name == null) {
            this.name = this.type.name;
            if (cx.statics.es4_nullability && !this.is_default) {
                this.name = new QName(this.name.ns, this.name.name + (this.is_nullable ? "?" : "!"));
            }
        }
        return this.name;
    }

    public Builder getBuilder() {
        return this.type.builder;
    }

    public ObjectValue getPrototype() {
        if (this.prototype == null) {
            this.prototype = this.type != null ? this.type.prototype : null;
        }
        return this.prototype;
    }

    public boolean isInterface() {
        return this.type.isInterface();
    }

    public void setPrototype(ObjectValue proto) {
        this.prototype = proto;
    }
}

