/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.asdoc;

import flex2.compiler.asdoc.DocComment;
import flex2.compiler.asdoc.DocCommentGenerator;
import flex2.compiler.asdoc.DocCommentTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TopLevelGenerator
implements DocCommentGenerator {
    StringBuilder xml = new StringBuilder();

    public String toString() {
        return this.xml.toString();
    }

    public void generate(DocCommentTable table) {
        this.xml.append("<asdoc>\n");
        for (String currentPackage : table.getPackages().keySet()) {
            for (String currentClass : table.getClassesAndInterfaces(currentPackage).keySet()) {
                Iterator commentsIterator = table.getAllClassComments(currentClass, currentPackage).iterator();
                while (commentsIterator.hasNext()) {
                    this.emitDocComment((DocComment)commentsIterator.next());
                }
            }
        }
        this.xml.append("\n</asdoc>\n");
    }

    private void appendTag(String tagName, String value) {
        this.xml.append("\n<");
        this.xml.append(tagName);
        this.xml.append("><![CDATA[");
        this.xml.append(value);
        this.xml.append("]]></");
        this.xml.append(tagName);
        this.xml.append(">");
    }

    private void emitTags(Map tags) {
        Iterator tagIterator = tags.keySet().iterator();
        while (tagIterator.hasNext()) {
            String value;
            String tagName2 = ((String)tagIterator.next()).intern();
            Object o = tags.get(tagName2);
            if (o == null) continue;
            if (o instanceof Boolean) {
                boolean b = (Boolean)o;
                if (!b) continue;
                this.appendTag(tagName2, "");
                continue;
            }
            if (o instanceof List) {
                List l = (List)o;
                for (int i = 0; i < l.size(); ++i) {
                    value = (String)l.get(i);
                    this.appendTag(tagName2, value);
                }
                continue;
            }
            if (o instanceof Map) {
                Map m = (Map)o;
                for (String tagName2 : m.keySet()) {
                    value = (String)m.get(tagName2);
                    this.appendTag(tagName2, value);
                }
                continue;
            }
            String value2 = (String)o;
            this.appendTag(tagName2, value2);
        }
    }

    private void emitMetadata(List metadata) {
        for (int i = 0; i < metadata.size(); ++i) {
            String since_meta;
            String replacement_meta;
            String message_meta;
            String inherit_meta;
            String enumeration_meta;
            String format_meta;
            String arrayType_meta;
            String kind_meta;
            String event_meta;
            String type_meta;
            DocComment meta = (DocComment)metadata.get(i);
            String metadataType = meta.getMetadataType().intern();
            this.xml.append("\n<metadata>\n");
            this.xml.append("\t<");
            this.xml.append(metadataType);
            this.xml.append(" owner='");
            this.xml.append(meta.getOwner());
            this.xml.append("' ");
            String name = meta.getName();
            if (!name.equals("IGNORE")) {
                this.xml.append("name='").append(name).append("' ");
            }
            if ((type_meta = meta.getType_meta()) != null) {
                this.xml.append("type='").append(type_meta).append("' ");
            }
            if ((event_meta = meta.getEvent_meta()) != null) {
                this.xml.append("event='").append(event_meta).append("' ");
            }
            if ((kind_meta = meta.getKind_meta()) != null) {
                this.xml.append("kind='").append(kind_meta).append("' ");
            }
            if ((arrayType_meta = meta.getArrayType_meta()) != null) {
                this.xml.append("arrayType='").append(arrayType_meta).append("' ");
            }
            if ((format_meta = meta.getFormat_meta()) != null) {
                this.xml.append("format='").append(format_meta).append("' ");
            }
            if ((enumeration_meta = meta.getEnumeration_meta()) != null) {
                this.xml.append("enumeration='").append(enumeration_meta).append("' ");
            }
            if ((inherit_meta = meta.getInherit_meta()) != null) {
                this.xml.append("inherit='").append(inherit_meta).append("' ");
            }
            if (metadataType == "Event" || metadataType == "Style" || metadataType == "Effect") {
                String theme_meta;
                message_meta = meta.getMessage_meta();
                if (message_meta != null) {
                    this.xml.append("deprecatedMessage='").append(message_meta).append("' ");
                }
                if ((replacement_meta = meta.getReplacement_meta()) != null) {
                    this.xml.append("deprecatedReplacement='").append(replacement_meta).append("' ");
                }
                if ((since_meta = meta.getSince_meta()) != null) {
                    this.xml.append("deprecatedSince='").append(since_meta).append("' ");
                }
                if (metadataType == "Style" && (theme_meta = meta.getTheme_meta()) != null) {
                    this.xml.append("theme='").append(theme_meta).append("' ");
                }
            } else if (metadataType == "SkinPart") {
                String required_meta;
                String variableType_meta = meta.getVariableType_meta();
                if (variableType_meta != null) {
                    this.xml.append("var_type='").append(variableType_meta).append("' ");
                }
                if ((required_meta = meta.getRequired_meta()) != null) {
                    this.xml.append("required='").append(required_meta).append("' ");
                } else {
                    this.xml.append("required='false' ");
                }
            } else {
                message_meta = meta.getMessage_meta();
                if (message_meta != null) {
                    this.xml.append("message='").append(message_meta).append("' ");
                }
                if ((replacement_meta = meta.getReplacement_meta()) != null) {
                    this.xml.append("replacement='").append(replacement_meta).append("' ");
                }
                if ((since_meta = meta.getSince_meta()) != null) {
                    this.xml.append("since='").append(since_meta).append("' ");
                }
            }
            this.xml.append(">");
            if (metadataType == "Event" || metadataType == "Style" || metadataType == "Effect" || metadataType == "SkinState" || metadataType == "SkinPart" || metadataType == "Alternative" || metadataType == "DiscouragedForProfile" || metadataType == "Experimental") {
                String desc = meta.getDescription();
                if (desc != null) {
                    this.appendTag("description", meta.getDescription());
                }
                this.emitTags(meta.getAllTags());
            }
            this.xml.append("\n\t</");
            this.xml.append(metadataType);
            this.xml.append(">\n</metadata>");
        }
    }

    private void emitPackage(DocComment comment) {
        this.xml.append("\n<packageRec name='");
        this.xml.append(comment.getFullname());
        this.xml.append("' fullname='");
        this.xml.append(comment.getFullname());
        this.xml.append("'>");
        String desc = comment.getDescription();
        if (desc != null) {
            this.appendTag("description", comment.getDescription());
        }
        this.emitTags(comment.getAllTags());
        this.xml.append("\n</packageRec>");
    }

    private void emitClass(DocComment comment) {
        String tagName = comment.getType() == 1 ? "classRec" : "interfaceRec";
        this.xml.append("\n<");
        this.xml.append(tagName);
        this.xml.append(" name='");
        this.xml.append(comment.getName());
        this.xml.append("' fullname='");
        this.xml.append(comment.getFullname());
        String sourcefile = comment.getSourceFile();
        if (sourcefile != null) {
            this.xml.append("' sourcefile='");
            this.xml.append(sourcefile);
        }
        this.xml.append("' namespace='");
        this.xml.append(comment.getNamespace());
        this.xml.append("' access='");
        this.xml.append(comment.getAccess());
        this.xml.append("' ");
        if (comment.getType() == 2) {
            String[] baseClasses = comment.getBaseclasses();
            if (baseClasses != null) {
                this.xml.append("baseClasses='");
                for (int i = 0; i < baseClasses.length; ++i) {
                    String baseclass = baseClasses[i];
                    if (baseclass == null) continue;
                    if (i != 0) {
                        this.xml.append(";");
                    }
                    this.xml.append(baseclass);
                }
                this.xml.append("' ");
            }
        } else {
            this.xml.append("baseclass='");
            this.xml.append(comment.getBaseClass());
            this.xml.append("' ");
            String[] interfaces = comment.getInterfaces();
            if (interfaces != null) {
                this.xml.append("interfaces='");
                for (int i = 0; i < interfaces.length; ++i) {
                    String inter = interfaces[i];
                    if (inter == null) continue;
                    if (i != 0) {
                        this.xml.append(";");
                    }
                    this.xml.append(inter);
                }
                this.xml.append("' ");
            }
        }
        this.xml.append("isFinal='");
        this.xml.append(comment.isFinal());
        this.xml.append("' ");
        this.xml.append("isDynamic='");
        this.xml.append(comment.isDynamic());
        this.xml.append("' ");
        this.xml.append(">");
        String desc = comment.getDescription();
        if (desc != null) {
            this.appendTag("description", comment.getDescription());
        }
        this.emitTags(comment.getAllTags());
        if (comment.getMetadata() != null) {
            this.emitMetadata(comment.getMetadata());
        }
        this.xml.append("\n</");
        this.xml.append(tagName);
        this.xml.append(">");
    }

    private void emitFunction(DocComment comment) {
        this.xml.append("\n<method name='");
        this.xml.append(comment.getName());
        this.xml.append("' fullname='");
        this.xml.append(comment.getFullname());
        this.xml.append("' ");
        this.xml.append("isStatic='");
        this.xml.append(comment.isStatic());
        this.xml.append("' ");
        this.xml.append("isFinal='");
        this.xml.append(comment.isFinal());
        this.xml.append("' ");
        this.xml.append("isOverride='");
        this.xml.append(comment.isOverride());
        this.xml.append("' ");
        String[] param_names = comment.getParamNames();
        if (param_names != null) {
            this.xml.append(" param_names='");
            for (int i = 0; i < param_names.length; ++i) {
                String pname = param_names[i];
                if (pname == null) continue;
                if (i != 0) {
                    this.xml.append(";");
                }
                this.xml.append(pname);
            }
            this.xml.append("'");
            String[] param_types = comment.getParamTypes();
            this.xml.append(" param_types='");
            for (int i = 0; i < param_types.length; ++i) {
                String ptype = param_types[i];
                if (ptype == null) continue;
                if (i != 0) {
                    this.xml.append(";");
                }
                this.xml.append(ptype);
            }
            this.xml.append("'");
            String[] param_defaults = comment.getParamDefaults();
            this.xml.append(" param_defaults='");
            for (int i = 0; i < param_defaults.length; ++i) {
                String pdefa = param_defaults[i];
                if (pdefa == null) continue;
                if (i != 0) {
                    this.xml.append(";");
                }
                this.xml.append(pdefa);
            }
            this.xml.append("'");
        }
        this.xml.append(" result_type='");
        this.xml.append(comment.getResultType());
        this.xml.append("'>");
        String desc = comment.getDescription();
        if (desc != null) {
            this.appendTag("description", comment.getDescription());
        }
        this.emitTags(comment.getAllTags());
        if (comment.getMetadata() != null) {
            this.emitMetadata(comment.getMetadata());
        }
        this.xml.append("\n</method>");
    }

    private void emitField(DocComment comment) {
        this.xml.append("\n<field name='");
        this.xml.append(comment.getName());
        this.xml.append("' fullname='");
        this.xml.append(comment.getFullname());
        this.xml.append("' type='");
        String type = comment.getVartype();
        if (type != null) {
            this.xml.append(comment.getVartype());
        }
        this.xml.append("' isStatic='");
        this.xml.append(comment.isStatic());
        this.xml.append("' isConst='");
        this.xml.append(comment.isConst());
        this.xml.append("' ");
        String defaultValue = comment.getDefaultValue();
        if (defaultValue != null) {
            this.xml.append("defaultValue='");
            try {
                Pattern pattern = Pattern.compile("\\p{Cntrl}");
                Matcher matcher = pattern.matcher(defaultValue);
                defaultValue = matcher.replaceAll("");
            }
            catch (Exception pattern) {
                // empty catch block
            }
            this.xml.append(defaultValue);
            this.xml.append("' ");
        }
        this.xml.append(">");
        String desc = comment.getDescription();
        if (desc != null) {
            this.appendTag("description", comment.getDescription());
        }
        this.emitTags(comment.getAllTags());
        if (comment.getMetadata() != null) {
            this.emitMetadata(comment.getMetadata());
        }
        this.xml.append("\n</field>");
    }

    private void emitDocComment(DocComment comment) {
        if (!comment.isExcluded()) {
            int type = comment.getType();
            if (type == 0) {
                this.emitPackage(comment);
            } else if (type == 1 || type == 2) {
                this.emitClass(comment);
            } else if (type >= 3 && type <= 5) {
                this.emitFunction(comment);
            } else if (type == 6) {
                this.emitField(comment);
            }
        }
    }
}

