/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.config;

import flex.messaging.config.LoginCommandSettings;
import flex.messaging.config.SecurityConstraint;
import flex.messaging.security.SecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SecuritySettings {
    private static final int NO_SEC_CONSTRAINT = 10062;
    private String serverInfo;
    private Map loginCommandSettings;
    private Map constraints = new HashMap();
    private boolean recreateHttpSessionAfterLogin;

    public SecuritySettings() {
        this.loginCommandSettings = new HashMap();
    }

    public void addConstraint(SecurityConstraint sc) {
        this.constraints.put(sc.getId(), sc);
    }

    public SecurityConstraint getConstraint(String ref) {
        if (this.constraints.get(ref) == null) {
            SecurityException se = new SecurityException();
            se.setMessage(10062, new Object[]{ref});
            throw se;
        }
        return (SecurityConstraint)this.constraints.get(ref);
    }

    public void addLoginCommandSettings(LoginCommandSettings lcs) {
        this.loginCommandSettings.put(lcs.getServer(), lcs);
    }

    public Map getLoginCommands() {
        return this.loginCommandSettings;
    }

    public Collection<SecurityConstraint> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints.values());
    }

    public void setServerInfo(String s) {
        this.serverInfo = s;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public boolean isRecreateHttpSessionAfterLogin() {
        return this.recreateHttpSessionAfterLogin;
    }

    public void setRecreateHttpSessionAfterLogin(boolean value) {
        this.recreateHttpSessionAfterLogin = value;
    }
}

