/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.Closeable;
import java.util.Iterator;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.cli.CliChangelogResultView;
import org.apache.flink.table.client.cli.CliResultView;
import org.apache.flink.table.client.cli.CliStrings;
import org.apache.flink.table.client.cli.CliTableResultView;
import org.apache.flink.table.client.cli.CliTableauResultView;
import org.apache.flink.table.client.cli.TerminalUtils;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.table.utils.print.RowDataToStringConverter;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;

public interface Printer
extends Closeable {
    public boolean isQuitCommand();

    public void print(Terminal var1);

    @Override
    default public void close() {
    }

    public static ClearCommandPrinter createClearCommandPrinter() {
        return ClearCommandPrinter.INSTANCE;
    }

    public static QuitCommandPrinter createQuitCommandPrinter() {
        return QuitCommandPrinter.INSTANCE;
    }

    public static HelpCommandPrinter createHelpCommandPrinter() {
        return HelpCommandPrinter.INSTANCE;
    }

    public static StatementResultPrinter createStatementCommandPrinter(StatementResult result, ReadableConfig sessionConfig) {
        return new StatementResultPrinter(result, sessionConfig);
    }

    public static InitializationCommandPrinter createInitializationCommandPrinter() {
        return InitializationCommandPrinter.INSTANCE;
    }

    public static void printInfo(Terminal terminal, String message) {
        terminal.writer().println(CliStrings.messageInfo(message).toAnsi());
        terminal.flush();
    }

    public static class StatementResultPrinter
    implements Printer {
        private final StatementResult result;
        private final ReadableConfig sessionConfig;

        public StatementResultPrinter(StatementResult result, ReadableConfig sessionConfig) {
            this.result = result;
            this.sessionConfig = sessionConfig;
        }

        @Override
        public boolean isQuitCommand() {
            return false;
        }

        @Override
        public void print(Terminal terminal) {
            if (this.result.isQueryResult()) {
                this.printQuery(terminal);
            } else if (this.result.getJobId() != null) {
                this.printJob(terminal, this.result.getJobId());
            } else {
                this.defaultPrint(terminal);
            }
        }

        private void printQuery(Terminal terminal) {
            ResultDescriptor resultDesc = new ResultDescriptor(this.result, this.sessionConfig);
            if (resultDesc.isTableauMode()) {
                try (CliTableauResultView tableauResultView = new CliTableauResultView(terminal, resultDesc);){
                    tableauResultView.displayResults();
                }
            } else {
                CliResultView view = resultDesc.isMaterialized() ? new CliTableResultView(terminal, resultDesc) : new CliChangelogResultView(terminal, resultDesc);
                view.open();
                Printer.printInfo(terminal, "Result retrieval cancelled.");
            }
        }

        private void printJob(Terminal terminal, JobID jobID) {
            if (((Boolean)this.sessionConfig.get(TableConfigOptions.TABLE_DML_SYNC)).booleanValue()) {
                Printer.printInfo(terminal, "Complete execution of the SQL update statement.");
            } else {
                terminal.writer().println(CliStrings.messageInfo("Submitting SQL update statement to the cluster...").toAnsi());
                terminal.writer().println(CliStrings.messageInfo("SQL update statement has been successfully submitted to the cluster:").toAnsi());
                terminal.writer().println(String.format("Job ID: %s\n", jobID));
                terminal.flush();
            }
        }

        private void defaultPrint(Terminal terminal) {
            if (this.result.getResultKind() == ResultKind.SUCCESS) {
                Printer.printInfo(terminal, "Execute statement succeed.");
            } else {
                PrintStyle.tableauWithDataInferredColumnWidths((ResolvedSchema)this.result.getResultSchema(), (RowDataToStringConverter)this.result.getRowDataToStringConverter(), (int)Integer.MAX_VALUE, (boolean)true, (boolean)false).print((Iterator)((Object)this.result), terminal.writer());
            }
        }

        @Override
        public void close() {
            this.result.close();
        }
    }

    public static class InitializationCommandPrinter
    implements Printer {
        static final InitializationCommandPrinter INSTANCE = new InitializationCommandPrinter();

        private InitializationCommandPrinter() {
        }

        @Override
        public boolean isQuitCommand() {
            return false;
        }

        @Override
        public void print(Terminal terminal) {
            Printer.printInfo(terminal, "Execute statement succeed.");
        }

        @Override
        public void close() {
        }
    }

    public static class ClearCommandPrinter
    implements Printer {
        private static final ClearCommandPrinter INSTANCE = new ClearCommandPrinter();

        @Override
        public boolean isQuitCommand() {
            return false;
        }

        @Override
        public void print(Terminal terminal) {
            if (TerminalUtils.isPlainTerminal(terminal)) {
                for (int i = 0; i < 200; ++i) {
                    terminal.writer().println();
                }
            } else {
                terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
            }
        }

        @Override
        public void close() {
        }
    }

    public static class QuitCommandPrinter
    implements Printer {
        private static final QuitCommandPrinter INSTANCE = new QuitCommandPrinter();

        @Override
        public boolean isQuitCommand() {
            return true;
        }

        @Override
        public void print(Terminal terminal) {
            Printer.printInfo(terminal, "Exiting Flink SQL CLI Client...");
        }

        @Override
        public void close() {
        }
    }

    public static class HelpCommandPrinter
    implements Printer {
        private static final HelpCommandPrinter INSTANCE = new HelpCommandPrinter();

        @Override
        public boolean isQuitCommand() {
            return false;
        }

        @Override
        public void print(Terminal terminal) {
            terminal.writer().println(CliStrings.MESSAGE_HELP);
            terminal.flush();
        }

        @Override
        public void close() {
        }
    }
}

