/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.scala.FieldAccessFinder;
import org.apache.flink.api.scala.FieldAccessFinder$;
import org.apache.flink.api.scala.InnerClosureFinder;
import org.apache.flink.api.scala.ReturnStatementFinder;
import org.apache.flink.api.scala.ReturnStatementFinder$;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassReader;
import org.apache.flink.shaded.asm9.org.objectweb.asm.ClassVisitor;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractTraversable;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import sun.reflect.ReflectionFactory;

@Internal
public final class ClosureCleaner$ {
    public static ClosureCleaner$ MODULE$;
    private final Logger LOG;

    static {
        new ClosureCleaner$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public ClassReader getClassReader(Class<?> cls) {
        ClassReader classReader;
        String className = new StringBuilder(6).append(cls.getName().replaceFirst("^.*\\.", "")).append(".class").toString();
        InputStream resourceStream = cls.getResourceAsStream(className);
        if (resourceStream == null) {
            classReader = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
            this.copyStream(resourceStream, baos, true);
            classReader = new ClassReader((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        }
        return classReader;
    }

    private boolean isClosure(Class<?> cls) {
        return cls.getName().contains("$anonfun$");
    }

    private Tuple2<List<Class<?>>, List<Object>> getOuterClassesAndObjects(Object obj) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])obj.getClass().getDeclaredFields())).withFilter((Function1<Object, Object>)(Function1<Field, Object> & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean(ClosureCleaner$.$anonfun$getOuterClassesAndObjects$1(f))).foreach((Function1<Field, Object> & Serializable & scala.Serializable)f -> {
                ClosureCleaner$.$anonfun$getOuterClassesAndObjects$2(obj, object, f);
                return BoxedUnit.UNIT;
            });
            tuple2 = new Tuple2<Nil$, Nil$>(Nil$.MODULE$, Nil$.MODULE$);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    private List<Class<?>> getInnerClosureClasses(Object obj) {
        Set seen = (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Class[]{obj.getClass()}));
        Stack stack = (Stack)Stack$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Class[]{obj.getClass()}));
        while (!stack.isEmpty()) {
            ClassReader cr = this.getClassReader((Class)stack.pop());
            if (cr == null) continue;
            GenTraversable set = Set$.MODULE$.empty();
            cr.accept((ClassVisitor)new InnerClosureFinder((Set<Class<?>>)set), 0);
            set.$minus$minus(seen).foreach((Function1<Class, Stack> & Serializable & scala.Serializable)cls -> {
                seen.$plus$eq(cls);
                return stack.push(cls);
            });
        }
        return seen.$minus(obj.getClass()).toList();
    }

    private void initAccessedFields(Map<Class<?>, Set<String>> accessedFields, Seq<Class<?>> outerClasses) {
        outerClasses.foreach((Function1<Class, Object> & Serializable & scala.Serializable)cls -> {
            ClosureCleaner$.$anonfun$initAccessedFields$1(accessedFields, cls);
            return BoxedUnit.UNIT;
        });
    }

    private void setAccessedFields(Class<?> outerClass, Object clone, Object obj, Map<Class<?>, Set<String>> accessedFields) {
        ((IterableLike)accessedFields.apply(outerClass)).foreach((Function1<String, Object> & Serializable & scala.Serializable)fieldName -> {
            ClosureCleaner$.$anonfun$setAccessedFields$1(outerClass, clone, obj, fieldName);
            return BoxedUnit.UNIT;
        });
    }

    private Object cloneAndSetFields(Object parent, Object obj, Class<?> outerClass, Map<Class<?>, Set<String>> accessedFields) {
        Object clone = this.instantiateClass(outerClass, parent);
        Class<?> currentClass = outerClass;
        Predef$.MODULE$.assert(currentClass != null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The outer class can't be null.");
        while (currentClass != null) {
            this.setAccessedFields(currentClass, clone, obj, accessedFields);
            currentClass = currentClass.getSuperclass();
        }
        return clone;
    }

    public void clean(Object closure, boolean checkSerializable, ExecutionConfig.ClosureCleanerLevel cleanLevel) {
        ExecutionConfig.ClosureCleanerLevel closureCleanerLevel = cleanLevel;
        ExecutionConfig.ClosureCleanerLevel closureCleanerLevel2 = ExecutionConfig.ClosureCleanerLevel.RECURSIVE;
        boolean cleanTransitively = !(closureCleanerLevel != null ? !closureCleanerLevel.equals(closureCleanerLevel2) : closureCleanerLevel2 != null);
        this.clean(closure, checkSerializable, cleanTransitively, (Map<Class<?>, Set<String>>)Map$.MODULE$.empty());
    }

    private Option<SerializedLambda> getSerializedLambda(Object closure) {
        Option option;
        boolean isClosureCandidate;
        boolean bl = isClosureCandidate = closure.getClass().isSynthetic() && new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])closure.getClass().getInterfaces())).exists((Function1<Object, Object>)(Function1<Class, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(ClosureCleaner$.$anonfun$getSerializedLambda$1(x$5)));
        if (isClosureCandidate) {
            try {
                option = Option$.MODULE$.apply(this.inspect(closure));
            }
            catch (Exception e) {
                if (this.LOG().isDebugEnabled()) {
                    this.LOG().debug("Closure is not a serialized lambda.", (Throwable)e);
                }
                option = None$.MODULE$;
            }
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private SerializedLambda inspect(Object closure) {
        Method writeReplace = closure.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        writeReplace.setAccessible(true);
        return (SerializedLambda)writeReplace.invoke(closure, new Object[0]);
    }

    private void clean(Object func, boolean checkSerializable, boolean cleanTransitively, Map<Class<?>, Set<String>> accessedFields) {
        block17: {
            Option<SerializedLambda> lambdaFunc = this.getSerializedLambda(func);
            if (!this.isClosure(func.getClass()) && lambdaFunc.isEmpty()) {
                this.LOG().debug(new StringBuilder(24).append("Expected a closure; got ").append(func.getClass().getName()).toString());
                return;
            }
            if (func == null) {
                return;
            }
            if (lambdaFunc.isEmpty()) {
                this.LOG().debug(new StringBuilder(28).append("+++ Cleaning closure ").append(func).append(" (").append(func.getClass().getName()).append(") +++").toString());
                List<Class<?>> innerClasses = this.getInnerClosureClasses(func);
                Tuple2<List<Class<?>>, List<Object>> tuple2 = this.getOuterClassesAndObjects(func);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                List<Class<?>> outerClasses = tuple2._1();
                List<Object> outerObjects = tuple2._2();
                Tuple2 tuple22 = new Tuple2(outerClasses, outerObjects);
                Tuple2 tuple23 = tuple22;
                List<Class<?>> outerClasses2 = tuple23._1();
                List<Object> outerObjects2 = tuple23._2();
                Field[] declaredFields = func.getClass().getDeclaredFields();
                Method[] declaredMethods = func.getClass().getDeclaredMethods();
                if (this.LOG().isDebugEnabled()) {
                    this.LOG().debug(new StringBuilder(20).append(" + declared fields: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])declaredFields)).size()).toString());
                    new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])declaredFields)).foreach((Function1<Field, Object> & Serializable & scala.Serializable)f -> {
                        ClosureCleaner$.$anonfun$clean$1(f);
                        return BoxedUnit.UNIT;
                    });
                    this.LOG().debug(new StringBuilder(21).append(" + declared methods: ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])declaredMethods)).size()).toString());
                    new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])declaredMethods)).foreach((Function1<Method, Object> & Serializable & scala.Serializable)m -> {
                        ClosureCleaner$.$anonfun$clean$2(m);
                        return BoxedUnit.UNIT;
                    });
                    this.LOG().debug(new StringBuilder(18).append(" + inner classes: ").append(innerClasses.size()).toString());
                    innerClasses.foreach((Function1<Class, Object> & Serializable & scala.Serializable)c -> {
                        ClosureCleaner$.$anonfun$clean$3(c);
                        return BoxedUnit.UNIT;
                    });
                    this.LOG().debug(new StringBuilder(18).append(" + outer classes: ").append(outerClasses2.size()).toString());
                    outerClasses2.foreach((Function1<Class, Object> & Serializable & scala.Serializable)c -> {
                        ClosureCleaner$.$anonfun$clean$4(c);
                        return BoxedUnit.UNIT;
                    });
                    this.LOG().debug(new StringBuilder(18).append(" + outer objects: ").append(outerObjects2.size()).toString());
                    outerObjects2.foreach((Function1<Object, Object> & Serializable & scala.Serializable)o -> {
                        ClosureCleaner$.$anonfun$clean$5(o);
                        return BoxedUnit.UNIT;
                    });
                }
                this.getClassReader(func.getClass()).accept((ClassVisitor)new ReturnStatementFinder(ReturnStatementFinder$.MODULE$.$lessinit$greater$default$1()), 0);
                if (accessedFields.isEmpty()) {
                    this.LOG().debug(" + populating accessed fields because this is the starting closure");
                    this.initAccessedFields(accessedFields, outerClasses2);
                    Class<?> clazz = func.getClass();
                    innerClasses.$colon$colon(clazz).foreach((Function1<Class, Object> & Serializable & scala.Serializable)cls -> {
                        ClosureCleaner$.$anonfun$clean$6(cleanTransitively, accessedFields, cls);
                        return BoxedUnit.UNIT;
                    });
                }
                this.LOG().debug(new StringBuilder(40).append(" + fields accessed by starting closure: ").append(accessedFields.size()).toString());
                accessedFields.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)f -> {
                    ClosureCleaner$.$anonfun$clean$7(f);
                    return BoxedUnit.UNIT;
                });
                Object outerPairs = outerClasses2.zip(outerObjects2, List$.MODULE$.canBuildFrom()).reverse();
                ObjectRef<Object> parent = ObjectRef.create(null);
                if (((AbstractTraversable)outerPairs).nonEmpty()) {
                    Tuple2 tuple24 = (Tuple2)((List)outerPairs).head();
                    if (tuple24 == null) {
                        throw new MatchError(tuple24);
                    }
                    Class outermostClass = (Class)tuple24._1();
                    Object outermostObject = tuple24._2();
                    Tuple2 tuple25 = new Tuple2(outermostClass, outermostObject);
                    Tuple2 tuple26 = tuple25;
                    Class outermostClass2 = tuple26._1();
                    Object outermostObject2 = tuple26._2();
                    if (this.isClosure(outermostClass2)) {
                        this.LOG().debug(new StringBuilder(50).append(" + outermost object is a closure, so we clone it: ").append(((List)outerPairs).head()).toString());
                    } else if (outermostClass2.getName().startsWith("$line")) {
                        this.LOG().debug(new StringBuilder(59).append(" + outermost object is a REPL line object, so we clone it: ").append(((List)outerPairs).head()).toString());
                    } else {
                        this.LOG().debug(new StringBuilder(77).append(" + outermost object is not a closure or REPL line object,so do not clone it: ").append(((List)outerPairs).head()).toString());
                        parent.elem = outermostObject2;
                        outerPairs = (List)((AbstractTraversable)outerPairs).tail();
                    }
                } else {
                    this.LOG().debug(" + there are no enclosing objects!");
                }
                ((AbstractTraversable)outerPairs).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ClosureCleaner$.$anonfun$clean$8(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$9 -> {
                    ClosureCleaner$.$anonfun$clean$9(cleanTransitively, accessedFields, parent, x$9);
                    return BoxedUnit.UNIT;
                });
                if (parent.elem != null) {
                    Field field2 = func.getClass().getDeclaredField("$outer");
                    field2.setAccessible(true);
                    if (accessedFields.contains(func.getClass()) && !((SetLike)accessedFields.apply(func.getClass())).contains("$outer")) {
                        this.LOG().debug(new StringBuilder(65).append(" + the starting closure doesn't actually need ").append(parent.elem).append(", so we null it out").toString());
                        field2.set(func, null);
                    } else {
                        field2.set(func, parent.elem);
                    }
                }
                this.LOG().debug(new StringBuilder(35).append(" +++ closure ").append(func).append(" (").append(func.getClass().getName()).append(") is now cleaned +++").toString());
            } else {
                this.LOG().debug(new StringBuilder(17).append("Cleaning lambda: ").append(lambdaFunc.get().getImplMethodName()).toString());
                Class<?> captClass = Class.forName(lambdaFunc.get().getCapturingClass().replace('/', '.'), false, Thread.currentThread().getContextClassLoader());
                this.getClassReader(captClass).accept((ClassVisitor)new ReturnStatementFinder(new Some<String>(lambdaFunc.get().getImplMethodName())), 0);
                this.LOG().debug(new StringBuilder(41).append(" +++ Lambda closure (").append(lambdaFunc.get().getImplMethodName()).append(") is now cleaned +++").toString());
            }
            if (!checkSerializable) break block17;
            this.ensureSerializable(func);
        }
    }

    public boolean clean$default$2() {
        return true;
    }

    public ExecutionConfig.ClosureCleanerLevel clean$default$3() {
        return ExecutionConfig.ClosureCleanerLevel.RECURSIVE;
    }

    public void ensureSerializable(Object func) {
        try {
            InstantiationUtil.serializeObject((Object)func);
        }
        catch (Exception ex) {
            throw new InvalidProgramException("Task not serializable", (Throwable)ex);
        }
    }

    private Object instantiateClass(Class<?> cls, Object enclosingObject) {
        Object obj;
        block0: {
            ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
            Constructor parentCtor = Object.class.getDeclaredConstructor(new Class[0]);
            Constructor<?> newCtor = rf.newConstructorForSerialization(cls, parentCtor);
            obj = newCtor.newInstance(new Object[0]);
            if (enclosingObject == null) break block0;
            Field field2 = cls.getDeclaredField("$outer");
            field2.setAccessible(true);
            field2.set(obj, enclosingObject);
        }
        return obj;
    }

    public long copyStream(InputStream in, OutputStream out, boolean closeStreams) {
        long l;
        try {
            long count;
            if (in instanceof FileInputStream && out instanceof FileOutputStream) {
                FileChannel inChannel = ((FileInputStream)in).getChannel();
                FileChannel outChannel = ((FileOutputStream)out).getChannel();
                long size = inChannel.size();
                for (count = 0L; count < size; count += inChannel.transferTo(count, size - count, outChannel)) {
                }
            } else {
                byte[] buf = new byte[8192];
                int n = 0;
                while (n != -1) {
                    n = in.read(buf);
                    if (n == -1) continue;
                    out.write(buf, 0, n);
                    count += (long)n;
                }
            }
            l = count;
        }
        catch (Throwable throwable) {
            if (closeStreams) {
                try {
                    in.close();
                }
                finally {
                    out.close();
                }
            }
            throw throwable;
        }
        long l2 = l;
        if (closeStreams) {
            try {
                in.close();
            }
            finally {
                out.close();
            }
        }
        return l2;
    }

    public boolean copyStream$default$3() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getOuterClassesAndObjects$1(Field f) {
        String string = f.getName();
        String string2 = "$outer";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$getOuterClassesAndObjects$2(Object obj$1, Object nonLocalReturnKey1$1, Field f) {
        f.setAccessible(true);
        Object outer = f.get(obj$1);
        if (outer != null) {
            if (MODULE$.isClosure(f.getType())) {
                Tuple2<List<Class<?>>, List<Object>> recurRet = MODULE$.getOuterClassesAndObjects(outer);
                Class<?> clazz = f.getType();
                Object object = outer;
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, new Tuple2(recurRet._1().$colon$colon(clazz), recurRet._2().$colon$colon(object)));
            }
            Class<?> clazz = f.getType();
            Object object = outer;
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, new Tuple2(Nil$.MODULE$.$colon$colon(clazz), Nil$.MODULE$.$colon$colon(object)));
        }
    }

    public static final /* synthetic */ void $anonfun$initAccessedFields$1(Map accessedFields$1, Class cls) {
        Class currentClass = cls;
        Predef$.MODULE$.assert(currentClass != null, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "The outer class can't be null.");
        while (currentClass != null) {
            accessedFields$1.update(currentClass, Set$.MODULE$.empty());
            currentClass = currentClass.getSuperclass();
        }
    }

    public static final /* synthetic */ void $anonfun$setAccessedFields$1(Class outerClass$1, Object clone$1, Object obj$2, String fieldName) {
        Field field2 = outerClass$1.getDeclaredField(fieldName);
        field2.setAccessible(true);
        Object value = field2.get(obj$2);
        field2.set(clone$1, value);
    }

    public static final /* synthetic */ boolean $anonfun$getSerializedLambda$1(Class x$5) {
        String string = x$5.getName();
        String string2 = "scala.Serializable";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$clean$1(Field f) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(f).toString());
    }

    public static final /* synthetic */ void $anonfun$clean$2(Method m) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(m).toString());
    }

    public static final /* synthetic */ void $anonfun$clean$3(Class c) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(c.getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$clean$4(Class c) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(c.getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$clean$5(Object o) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(o).toString());
    }

    public static final /* synthetic */ void $anonfun$clean$6(boolean cleanTransitively$1, Map accessedFields$2, Class cls) {
        MODULE$.getClassReader(cls).accept((ClassVisitor)new FieldAccessFinder(accessedFields$2, cleanTransitively$1, FieldAccessFinder$.MODULE$.$lessinit$greater$default$3(), FieldAccessFinder$.MODULE$.$lessinit$greater$default$4()), 0);
    }

    public static final /* synthetic */ void $anonfun$clean$7(Tuple2 f) {
        MODULE$.LOG().debug(new StringBuilder(5).append("     ").append(f).toString());
    }

    public static final /* synthetic */ boolean $anonfun$clean$8(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$clean$9(boolean cleanTransitively$1, Map accessedFields$2, ObjectRef parent$1, Tuple2 x$9) {
        Object clone;
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            Class cls = (Class)tuple2._1();
            Object obj = tuple2._2();
            MODULE$.LOG().debug(new StringBuilder(32).append(" + cloning the object ").append(obj).append(" of class ").append(cls.getName()).toString());
            clone = MODULE$.cloneAndSetFields(parent$1.elem, obj, cls, accessedFields$2);
            if (cleanTransitively$1 && MODULE$.isClosure(clone.getClass())) {
                MODULE$.LOG().debug(new StringBuilder(42).append(" + cleaning cloned closure ").append(clone).append(" recursively (").append(cls.getName()).append(")").toString());
                MODULE$.clean(clone, false, cleanTransitively$1, accessedFields$2);
            }
        } else {
            throw new MatchError(tuple2);
        }
        parent$1.elem = clone;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ClosureCleaner$() {
        MODULE$ = this;
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

