/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over.frame;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.operators.over.frame.UnboundedFollowingOverFrame;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.types.logical.RowType;

public class RangeUnboundedFollowingOverFrame
extends UnboundedFollowingOverFrame {
    private GeneratedRecordComparator boundComparator;
    private RecordComparator lbound;

    public RangeUnboundedFollowingOverFrame(RowType valueType, GeneratedAggsHandleFunction aggsHandleFunction, GeneratedRecordComparator boundComparator) {
        super(valueType, aggsHandleFunction);
        this.boundComparator = boundComparator;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        this.lbound = (RecordComparator)this.boundComparator.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.boundComparator = null;
    }

    @Override
    public RowData process(int index, RowData current) throws Exception {
        boolean bufferUpdated = index == 0;
        ResettableExternalBuffer.BufferIterator iterator = this.input.newIterator(this.inputIndex);
        BinaryRowData nextRow = OverWindowFrame.getNextOrNull(iterator);
        while (nextRow != null && this.lbound.compare((RowData)nextRow, current) < 0) {
            ++this.inputIndex;
            bufferUpdated = true;
            nextRow = OverWindowFrame.getNextOrNull(iterator);
        }
        return this.accumulateIterator(bufferUpdated, nextRow, iterator);
    }
}

