/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.typeutils.TimestampDataSerializer;

@Internal
public class TimestampDataTypeInfo
extends TypeInformation<TimestampData> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public TimestampDataTypeInfo(int precision) {
        this.precision = precision;
    }

    public boolean isBasicType() {
        return true;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<TimestampData> getTypeClass() {
        return TimestampData.class;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<TimestampData> createSerializer(ExecutionConfig config) {
        return new TimestampDataSerializer(this.precision);
    }

    public String toString() {
        return String.format("Timestamp(%d)", this.precision);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimestampDataTypeInfo)) {
            return false;
        }
        TimestampDataTypeInfo that = (TimestampDataTypeInfo)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass().getCanonicalName(), this.precision);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof TimestampDataTypeInfo;
    }

    public int getPrecision() {
        return this.precision;
    }
}

