/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.table.types;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;

@Internal
public class RowDataGenerator
implements DataGenerator<RowData> {
    private static final long serialVersionUID = 1L;
    private final DataGenerator<?>[] fieldGenerators;
    private final List<String> fieldNames;
    private final float nullRate;

    public RowDataGenerator(DataGenerator<?>[] fieldGenerators, List<String> fieldNames, float nullRate) {
        this.fieldGenerators = fieldGenerators;
        this.fieldNames = fieldNames;
        this.nullRate = nullRate;
    }

    public void open(String name, FunctionInitializationContext context, RuntimeContext runtimeContext) throws Exception {
        for (int i = 0; i < this.fieldGenerators.length; ++i) {
            this.fieldGenerators[i].open(this.fieldNames.get(i), context, runtimeContext);
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        for (DataGenerator<?> generator : this.fieldGenerators) {
            generator.snapshotState(context);
        }
    }

    public boolean hasNext() {
        for (DataGenerator<?> generator : this.fieldGenerators) {
            if (generator.hasNext()) continue;
            return false;
        }
        return true;
    }

    public RowData next() {
        if (this.nullRate == 0.0f || ThreadLocalRandom.current().nextFloat() > this.nullRate) {
            GenericRowData row = new GenericRowData(this.fieldNames.size());
            for (int i = 0; i < this.fieldGenerators.length; ++i) {
                row.setField(i, this.fieldGenerators[i].next());
            }
            return row;
        }
        return null;
    }
}

