/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPropertiesUtil;
import org.apache.flink.table.catalog.DefaultCatalogTable;

@PublicEvolving
public interface CatalogTable
extends CatalogBaseTable {
    public static CatalogTable of(Schema schema, @Nullable String comment, List<String> partitionKeys, Map<String, String> options) {
        return new DefaultCatalogTable(schema, comment, partitionKeys, options);
    }

    public static CatalogTable of(Schema schema, @Nullable String comment, List<String> partitionKeys, Map<String, String> options, @Nullable Long snapshot) {
        return new DefaultCatalogTable(schema, comment, partitionKeys, options, snapshot);
    }

    public static CatalogTable fromProperties(Map<String, String> properties) {
        return CatalogPropertiesUtil.deserializeCatalogTable(properties);
    }

    @Override
    default public CatalogBaseTable.TableKind getTableKind() {
        return CatalogBaseTable.TableKind.TABLE;
    }

    public boolean isPartitioned();

    public List<String> getPartitionKeys();

    public CatalogTable copy(Map<String, String> var1);

    @Deprecated
    default public Map<String, String> toProperties() {
        return Collections.emptyMap();
    }

    default public Optional<Long> getSnapshot() {
        return Optional.empty();
    }
}

