/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.api.config;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class SqlGatewayServiceConfigOptions {
    public static final ConfigOption<Duration> SQL_GATEWAY_SESSION_IDLE_TIMEOUT = ConfigOptions.key((String)"sql-gateway.session.idle-timeout").durationType().defaultValue((Object)Duration.ofMinutes(10L)).withDescription("Timeout interval for closing the session when the session hasn't been accessed during the interval. If setting to zero, the session will not be closed.");
    public static final ConfigOption<Duration> SQL_GATEWAY_SESSION_CHECK_INTERVAL = ConfigOptions.key((String)"sql-gateway.session.check-interval").durationType().defaultValue((Object)Duration.ofMinutes(1L)).withDescription("The check interval for idle session timeout, which can be disabled by setting to zero.");
    public static final ConfigOption<Integer> SQL_GATEWAY_SESSION_MAX_NUM = ConfigOptions.key((String)"sql-gateway.session.max-num").intType().defaultValue((Object)1000000).withDescription("The maximum number of the active session for sql gateway service.");
    public static final ConfigOption<Integer> SQL_GATEWAY_WORKER_THREADS_MAX = ConfigOptions.key((String)"sql-gateway.worker.threads.max").intType().defaultValue((Object)500).withDescription("The maximum number of worker threads for sql gateway service.");
    public static final ConfigOption<Integer> SQL_GATEWAY_WORKER_THREADS_MIN = ConfigOptions.key((String)"sql-gateway.worker.threads.min").intType().defaultValue((Object)5).withDescription("The minimum number of worker threads for sql gateway service.");
    public static final ConfigOption<Duration> SQL_GATEWAY_WORKER_KEEPALIVE_TIME = ConfigOptions.key((String)"sql-gateway.worker.keepalive-time").durationType().defaultValue((Object)Duration.ofMinutes(5L)).withDescription("Keepalive time for an idle worker thread. When the number of workers exceeds min workers, excessive threads are killed after this time interval.");
}

