/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.exceptions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;

@PublicEvolving
public class PartitionNotExistException
extends Exception {
    private static final String MSG = "Partition %s of table %s in catalog %s does not exist.";

    public PartitionNotExistException(String catalogName, ObjectPath tablePath, CatalogPartitionSpec partitionSpec) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName), null);
    }

    public PartitionNotExistException(String catalogName, ObjectPath tablePath, CatalogPartitionSpec partitionSpec, Throwable cause) {
        super(String.format(MSG, partitionSpec, tablePath.getFullName(), catalogName), cause);
    }
}

