/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class ArrayMinFunction
extends BuiltInScalarFunction {
    private final ArrayData.ElementGetter elementGetter;
    private final SpecializedFunction.ExpressionEvaluator compareEvaluator;
    private transient MethodHandle compareHandle;

    public ArrayMinFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ARRAY_MIN, context);
        DataType dataType = ((CollectionDataType)context.getCallContext().getArgumentDataTypes().get(0)).getElementDataType();
        this.elementGetter = ArrayData.createElementGetter((LogicalType)dataType.getLogicalType());
        this.compareEvaluator = context.createEvaluator((Expression)Expressions.$((String)"element1").isLess((Object)Expressions.$((String)"element2")), (DataType)DataTypes.BOOLEAN().notNull(), new DataTypes.Field[]{DataTypes.FIELD((String)"element1", (DataType)((DataType)dataType.notNull()).toInternal()), DataTypes.FIELD((String)"element2", (DataType)((DataType)dataType.notNull()).toInternal())});
    }

    public void open(FunctionContext context) throws Exception {
        this.compareHandle = this.compareEvaluator.open(context);
    }

    @Nullable
    public Object eval(ArrayData array) {
        try {
            if (array == null || array.size() == 0) {
                return null;
            }
            Object minElement = null;
            for (int i = 0; i < array.size(); ++i) {
                Object element = this.elementGetter.getElementOrNull(array, i);
                if (element == null || minElement != null && !this.compareHandle.invoke(element, minElement)) continue;
                minElement = element;
            }
            return minElement;
        }
        catch (Throwable t) {
            throw new FlinkRuntimeException(t);
        }
    }

    public void close() throws Exception {
        this.compareEvaluator.close();
    }
}

