/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.exceptions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ObjectPath;

@PublicEvolving
public class ModelNotExistException
extends Exception {
    private static final String MSG = "Model '`%s`.`%s`.`%s`' does not exist.";
    private static final String MSG_WITHOUT_CATALOG = "Model '`%s`.`%s`' does not exist.";

    public ModelNotExistException(String catalogName, ObjectPath modelPath) {
        this(catalogName, modelPath, null);
    }

    public ModelNotExistException(String catalogName, ObjectPath modelPath, Throwable cause) {
        super(ModelNotExistException.formatMsg(catalogName, modelPath), cause);
    }

    private static String formatMsg(String catalogName, ObjectPath modelPath) {
        if (catalogName != null) {
            return String.format(MSG, catalogName, modelPath.getDatabaseName(), modelPath.getObjectName());
        }
        return String.format(MSG_WITHOUT_CATALOG, modelPath.getDatabaseName(), modelPath.getObjectName());
    }
}

