/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.SqlCallSyntax;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.util.Preconditions;

@Internal
public final class BuiltInFunctionDefinition
implements SpecializedFunction {
    private final String name;
    @Nullable
    private final Integer version;
    private final FunctionKind kind;
    private final TypeInference typeInference;
    private final boolean isDeterministic;
    private final boolean isRuntimeProvided;
    @Nullable
    private final String runtimeClass;
    private final boolean isInternal;
    private final SqlCallSyntax sqlCallSyntax;
    private final String sqlName;
    private static final Pattern INTERNAL_NAME_PATTERN = Pattern.compile("\\$[A-Z0-9_ $]+\\$[1-9][0-9]*");
    private static final String INTERNAL_NAME_FORMAT = "$%s$%s";
    public static final int DEFAULT_VERSION = 1;

    private BuiltInFunctionDefinition(String name, String sqlName, int version, FunctionKind kind, TypeInference typeInference, SqlCallSyntax sqlCallSyntax, boolean isDeterministic, boolean isRuntimeProvided, String runtimeClass, boolean isInternal) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"Name must not be null.");
        this.sqlName = sqlName;
        this.version = isInternal ? null : Integer.valueOf(version);
        this.kind = (FunctionKind)((Object)Preconditions.checkNotNull((Object)((Object)kind), (String)"Kind must not be null."));
        this.typeInference = (TypeInference)Preconditions.checkNotNull((Object)typeInference, (String)"Type inference must not be null.");
        this.isDeterministic = isDeterministic;
        this.isRuntimeProvided = isRuntimeProvided;
        this.runtimeClass = runtimeClass;
        this.isInternal = isInternal;
        this.sqlCallSyntax = sqlCallSyntax;
        BuiltInFunctionDefinition.validateFunction(this.name, this.version, this.isInternal);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getSqlName() {
        if (this.sqlName != null) {
            return this.sqlName;
        }
        return this.getName().toUpperCase(Locale.ROOT);
    }

    public Optional<Integer> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> getRuntimeClass() {
        return Optional.ofNullable(this.runtimeClass);
    }

    public boolean hasRuntimeImplementation() {
        return this.isRuntimeProvided || this.runtimeClass != null;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public String getQualifiedName() {
        if (this.isInternal) {
            return this.name;
        }
        assert (this.version != null);
        return BuiltInFunctionDefinition.qualifyFunctionName(this.name, this.version);
    }

    @Override
    public UserDefinedFunction specialize(SpecializedFunction.SpecializedContext context) {
        if (this.runtimeClass == null) {
            throw new TableException(String.format("Could not find a runtime implementation for built-in function '%s'. The planner should have provided an implementation.", this.name));
        }
        try {
            Class<?> udfClass = Class.forName(this.runtimeClass, true, context.getBuiltInClassLoader());
            if (SpecializedFunction.class.isAssignableFrom(udfClass)) {
                SpecializedFunction specializedFunction = (SpecializedFunction)udfClass.newInstance();
                return specializedFunction.specialize(context);
            }
            Constructor<?> udfConstructor = udfClass.getConstructor(SpecializedFunction.SpecializedContext.class);
            return (UserDefinedFunction)udfConstructor.newInstance(context);
        }
        catch (Exception e) {
            throw new TableException(String.format("Could not instantiate a runtime implementation for built-in function '%s'.", this.name), e);
        }
    }

    @Override
    public FunctionKind getKind() {
        return this.kind;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return this.typeInference;
    }

    public SqlCallSyntax getCallSyntax() {
        return this.sqlCallSyntax;
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public String toString() {
        return this.name;
    }

    public static void validateFunction(String name, @Nullable Integer version, boolean isInternal) {
        if (isInternal) {
            Preconditions.checkArgument((boolean)INTERNAL_NAME_PATTERN.matcher(name).matches(), (String)"Internal function '%s' does not adhere to the naming convention: %s", (Object[])new Object[]{name, INTERNAL_NAME_PATTERN});
            Preconditions.checkArgument((version == null ? 1 : 0) != 0, (Object)"Internal function must not define a version.");
        } else {
            Preconditions.checkArgument((version == null || version >= 1 ? 1 : 0) != 0, (Object)"Version must be at least 1.");
        }
    }

    public static String qualifyFunctionName(String name, int version) {
        return String.format(INTERNAL_NAME_FORMAT, name.toUpperCase(Locale.ROOT), version);
    }

    @Internal
    public static final class Builder {
        private String name;
        private String sqlName;
        private int version = 1;
        private FunctionKind kind;
        private final TypeInference.Builder typeInferenceBuilder = TypeInference.newBuilder();
        private boolean isDeterministic = true;
        private boolean isRuntimeProvided = false;
        private String runtimeClass;
        private boolean isInternal = false;
        private SqlCallSyntax sqlCallSyntax = SqlCallSyntax.FUNCTION;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder kind(FunctionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder staticArguments(StaticArgument ... staticArguments) {
            this.typeInferenceBuilder.staticArguments(staticArguments);
            return this;
        }

        @Deprecated
        public Builder namedArguments(String ... argumentNames) {
            this.typeInferenceBuilder.namedArguments(Arrays.asList(argumentNames));
            return this;
        }

        @Deprecated
        public Builder typedArguments(DataType ... argumentTypes) {
            this.typeInferenceBuilder.typedArguments(Arrays.asList(argumentTypes));
            return this;
        }

        public Builder inputTypeStrategy(InputTypeStrategy inputTypeStrategy) {
            this.typeInferenceBuilder.inputTypeStrategy(inputTypeStrategy);
            return this;
        }

        public Builder outputTypeStrategy(TypeStrategy outputTypeStrategy) {
            this.typeInferenceBuilder.outputTypeStrategy(outputTypeStrategy);
            return this;
        }

        public Builder notDeterministic() {
            this.isDeterministic = false;
            return this;
        }

        public Builder runtimeProvided() {
            this.isRuntimeProvided = true;
            return this;
        }

        public Builder runtimeClass(String runtimeClass) {
            this.runtimeClass = runtimeClass;
            return this;
        }

        public Builder runtimeDeferred() {
            return this;
        }

        public Builder internal() {
            this.isInternal = true;
            return this;
        }

        public Builder callSyntax(SqlCallSyntax syntax) {
            this.sqlCallSyntax = syntax;
            return this;
        }

        public Builder callSyntax(String name, SqlCallSyntax syntax) {
            this.sqlName = name;
            this.sqlCallSyntax = syntax;
            return this;
        }

        public Builder sqlName(String name) {
            this.sqlName = name;
            return this;
        }

        public BuiltInFunctionDefinition build() {
            return new BuiltInFunctionDefinition(this.name, this.sqlName, this.version, this.kind, this.typeInferenceBuilder.build(), this.sqlCallSyntax, this.isDeterministic, this.isRuntimeProvided, this.runtimeClass, this.isInternal);
        }
    }
}

