/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.types.extraction.TypeInferenceExtractor;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.util.Collector;

@PublicEvolving
public abstract class ProcessTableFunction<T>
extends UserDefinedFunction {
    private transient Collector<T> collector;

    public final void setCollector(Collector<T> collector) {
        this.collector = collector;
    }

    protected final void collect(T row) {
        this.collector.collect(row);
    }

    @Override
    public final FunctionKind getKind() {
        return FunctionKind.PROCESS_TABLE;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInferenceExtractor.forProcessTableFunction(typeFactory, this.getClass());
    }

    @PublicEvolving
    public static interface OnTimerContext
    extends Context {
        public String currentTimer();
    }

    @PublicEvolving
    public static interface TimeContext<TimeType> {
        public TimeType time();

        public TimeType currentWatermark();

        public void registerOnTime(String var1, TimeType var2);

        public void registerOnTime(TimeType var1);

        public void clearTimer(String var1);

        public void clearTimer(TimeType var1);

        public void clearAllTimers();
    }

    @PublicEvolving
    public static interface Context {
        public <TimeType> TimeContext<TimeType> timeContext(Class<TimeType> var1);

        public TableSemantics tableSemanticsFor(String var1);

        public void clearState(String var1);

        public void clearAllState();

        public void clearAllTimers();

        public void clearAll();

        public ChangelogMode getChangelogMode();
    }
}

