/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.legacy.api.constraints;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.legacy.api.constraints.Constraint;
import org.apache.flink.util.Preconditions;

@Internal
abstract class AbstractConstraint
implements Constraint {
    private final String name;
    private final boolean enforced;

    AbstractConstraint(String name, boolean enforced) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.enforced = enforced;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnforced() {
        return this.enforced;
    }

    public String toString() {
        return this.asSummaryString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstraint that = (AbstractConstraint)o;
        return this.enforced == that.enforced && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.enforced);
    }
}

