/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.Variant;

@PublicEvolving
public final class VariantType
extends LogicalType {
    private static final Set<String> INPUT_OUTPUT_CONVERSION = VariantType.conversionSet(Variant.class.getName(), BinaryVariant.class.getName());

    public VariantType(boolean isNullable) {
        super(isNullable, LogicalTypeRoot.VARIANT);
    }

    public VariantType() {
        this(true);
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new VariantType(isNullable);
    }

    @Override
    public String asSerializableString() {
        return this.withNullability("VARIANT", new Object[0]);
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return Variant.class;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

