/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.writer.RequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;

@Internal
public class DequeRequestBuffer<RequestEntryT extends Serializable>
implements RequestBuffer<RequestEntryT> {
    private final Deque<RequestEntryWrapper<RequestEntryT>> buffer = new ArrayDeque<RequestEntryWrapper<RequestEntryT>>();
    private long totalSizeInBytes = 0L;

    @Override
    public void add(RequestEntryWrapper<RequestEntryT> entry, boolean prioritize) {
        if (prioritize) {
            this.buffer.addFirst(entry);
        } else {
            this.buffer.add(entry);
        }
        this.totalSizeInBytes += entry.getSize();
    }

    @Override
    public RequestEntryWrapper<RequestEntryT> peek() {
        return this.buffer.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public int size() {
        return this.buffer.size();
    }

    @Override
    public Collection<RequestEntryWrapper<RequestEntryT>> getBufferedState() {
        return new ArrayList<RequestEntryWrapper<RequestEntryT>>(this.buffer);
    }

    @Override
    public RequestEntryWrapper<RequestEntryT> poll() {
        RequestEntryWrapper<RequestEntryT> entry = this.buffer.poll();
        if (entry != null) {
            this.totalSizeInBytes = Math.max(0L, this.totalSizeInBytes - entry.getSize());
        }
        return entry;
    }

    @Override
    public long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }
}

