/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream;

import java.io.IOException;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.FileSystemConnectorOptions;
import org.apache.flink.connector.file.table.stream.PartitionCommitPredicate;
import org.apache.flink.connector.file.table.stream.PartitionTimeCommitTrigger;
import org.apache.flink.connector.file.table.stream.ProcTimeCommitTrigger;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public interface PartitionCommitTrigger {
    public void addPartition(String var1);

    public List<String> committablePartitions(long var1) throws IOException;

    public List<String> endInput();

    public void snapshotState(long var1, long var3) throws Exception;

    public static PartitionCommitTrigger create(boolean isRestored, OperatorStateStore stateStore, Configuration conf, ClassLoader cl, List<String> partitionKeys, ProcessingTimeService procTimeService) throws Exception {
        FileSystemConnectorOptions.PartitionCommitTriggerType trigger = (FileSystemConnectorOptions.PartitionCommitTriggerType)((Object)conf.get(FileSystemConnectorOptions.SINK_PARTITION_COMMIT_TRIGGER));
        switch (trigger) {
            case PARTITION_TIME: {
                PartitionCommitPredicate partitionCommitPredicate = PartitionCommitPredicate.createPartitionTimeCommitPredicate(conf, cl, partitionKeys);
                return new PartitionTimeCommitTrigger(isRestored, stateStore, partitionCommitPredicate);
            }
            case PROCESS_TIME: {
                PartitionCommitPredicate partitionCommitPredicate = PartitionCommitPredicate.createProcTimeCommitPredicate(conf);
                return new ProcTimeCommitTrigger(isRestored, stateStore, procTimeService, partitionCommitPredicate);
            }
        }
        throw new UnsupportedOperationException("Unsupported partition commit trigger: " + String.valueOf((Object)trigger));
    }
}

