/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class EndsWithFunction
extends BuiltInScalarFunction {
    public EndsWithFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.ENDS_WITH, context);
    }

    @Nullable
    public Boolean eval(@Nullable StringData expr, @Nullable StringData endExpr) {
        if (expr == null || endExpr == null) {
            return null;
        }
        if (BinaryStringDataUtil.isEmpty((BinaryStringData)endExpr)) {
            return true;
        }
        return ((BinaryStringData)expr).endsWith((BinaryStringData)endExpr);
    }

    @Nullable
    public Boolean eval(@Nullable byte[] expr, @Nullable byte[] endExpr) {
        if (expr == null || endExpr == null) {
            return null;
        }
        if (endExpr.length == 0) {
            return true;
        }
        return EndsWithFunction.matchAtEnd(expr, endExpr);
    }

    private static boolean matchAtEnd(byte[] source, byte[] target) {
        int start = source.length - target.length;
        if (start < 0) {
            return false;
        }
        for (int i = start; i < source.length; ++i) {
            if (source[i] == target[i - start]) continue;
            return false;
        }
        return true;
    }
}

