/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.async;

import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.api.common.state.v2.ValueStateDescriptor;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.operators.aggregate.GroupAggFunctionBase;
import org.apache.flink.table.runtime.operators.aggregate.utils.GroupAggHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStateGroupAggFunction
extends GroupAggFunctionBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AsyncStateGroupAggFunction.class);
    private transient ValueState<RowData> accState = null;
    private transient AsyncStateGroupAggHelper aggHelper = null;

    public AsyncStateGroupAggFunction(GeneratedAggsHandleFunction genAggsHandler, GeneratedRecordEqualiser genRecordEqualiser, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore, long stateRetentionTime) {
        super(genAggsHandler, genRecordEqualiser, accTypes, indexOfCountStar, generateUpdateBefore, stateRetentionTime);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        LOG.info("Group agg is using async state");
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", accTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            accDesc.enableTimeToLive(this.ttlConfig);
        }
        this.accState = this.getRuntimeContext().getState(accDesc);
        this.aggHelper = new AsyncStateGroupAggHelper();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        RowData currentKey = (RowData)ctx.getCurrentKey();
        this.accState.asyncValue().thenAccept(acc -> this.aggHelper.processElement(input, currentKey, (RowData)acc, out));
    }

    private class AsyncStateGroupAggHelper
    extends GroupAggHelper {
        public AsyncStateGroupAggHelper() {
            super(AsyncStateGroupAggFunction.this.recordCounter, AsyncStateGroupAggFunction.this.generateUpdateBefore, AsyncStateGroupAggFunction.this.ttlConfig, AsyncStateGroupAggFunction.this.function, AsyncStateGroupAggFunction.this.equaliser);
        }

        @Override
        protected void updateAccumulatorsState(RowData accumulators) throws Exception {
            AsyncStateGroupAggFunction.this.accState.asyncUpdate((Object)accumulators);
        }

        @Override
        protected void clearAccumulatorsState() throws Exception {
            AsyncStateGroupAggFunction.this.accState.asyncClear();
        }
    }
}

