/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.variant.Variant;

public class RepeatedRowData
implements RowData {
    private final int count;
    private RowData row;

    public RepeatedRowData(int count) {
        this.count = count;
    }

    public RepeatedRowData replace(RowData row) {
        this.row = row;
        return this;
    }

    public int getArity() {
        return this.row.getArity() * this.count;
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    public boolean isNullAt(int pos) {
        return this.row.isNullAt(pos / this.count);
    }

    public boolean getBoolean(int pos) {
        return this.row.getBoolean(pos / this.count);
    }

    public byte getByte(int pos) {
        return this.row.getByte(pos / this.count);
    }

    public short getShort(int pos) {
        return this.row.getShort(pos / this.count);
    }

    public int getInt(int pos) {
        return this.row.getInt(pos / this.count);
    }

    public long getLong(int pos) {
        return this.row.getLong(pos / this.count);
    }

    public float getFloat(int pos) {
        return this.row.getFloat(pos / this.count);
    }

    public double getDouble(int pos) {
        return this.row.getDouble(pos / this.count);
    }

    public StringData getString(int pos) {
        return this.row.getString(pos / this.count);
    }

    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(pos / this.count, precision, scale);
    }

    public TimestampData getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(pos / this.count, precision);
    }

    public <T> RawValueData<T> getRawValue(int pos) {
        return this.row.getRawValue(pos / this.count);
    }

    public byte[] getBinary(int pos) {
        return this.row.getBinary(pos / this.count);
    }

    public ArrayData getArray(int pos) {
        return this.row.getArray(pos / this.count);
    }

    public MapData getMap(int pos) {
        return this.row.getMap(pos / this.count);
    }

    public RowData getRow(int pos, int numFields) {
        return this.row.getRow(pos / this.count, numFields);
    }

    public Variant getVariant(int pos) {
        return this.row.getVariant(pos / this.count);
    }
}

